@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.inputs

import com.pulumi.aws.inputs.ProviderIgnoreTagsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property keyPrefixes Resource tag key prefixes to ignore across all resources. Can also be configured with the TF_AWS_IGNORE_TAGS_KEY_PREFIXES environment variable.
 * @property keys Resource tag keys to ignore across all resources. Can also be configured with the TF_AWS_IGNORE_TAGS_KEYS environment variable.
 */
public data class ProviderIgnoreTagsArgs(
    public val keyPrefixes: Output<List<String>>? = null,
    public val keys: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.inputs.ProviderIgnoreTagsArgs> {
    override fun toJava(): com.pulumi.aws.inputs.ProviderIgnoreTagsArgs =
        com.pulumi.aws.inputs.ProviderIgnoreTagsArgs.builder()
            .keyPrefixes(keyPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .keys(keys?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ProviderIgnoreTagsArgs].
 */
@PulumiTagMarker
public class ProviderIgnoreTagsArgsBuilder internal constructor() {
    private var keyPrefixes: Output<List<String>>? = null

    private var keys: Output<List<String>>? = null

    /**
     * @param value Resource tag key prefixes to ignore across all resources. Can also be configured with the TF_AWS_IGNORE_TAGS_KEY_PREFIXES environment variable.
     */
    @JvmName("mosdtcguxeaimjpf")
    public suspend fun keyPrefixes(`value`: Output<List<String>>) {
        this.keyPrefixes = value
    }

    @JvmName("duaypfcmsmqrmybh")
    public suspend fun keyPrefixes(vararg values: Output<String>) {
        this.keyPrefixes = Output.all(values.asList())
    }

    /**
     * @param values Resource tag key prefixes to ignore across all resources. Can also be configured with the TF_AWS_IGNORE_TAGS_KEY_PREFIXES environment variable.
     */
    @JvmName("apqipsfcnlnxbkct")
    public suspend fun keyPrefixes(values: List<Output<String>>) {
        this.keyPrefixes = Output.all(values)
    }

    /**
     * @param value Resource tag keys to ignore across all resources. Can also be configured with the TF_AWS_IGNORE_TAGS_KEYS environment variable.
     */
    @JvmName("ejdotkshwvibkwbd")
    public suspend fun keys(`value`: Output<List<String>>) {
        this.keys = value
    }

    @JvmName("xvmhgwhyetimsiwm")
    public suspend fun keys(vararg values: Output<String>) {
        this.keys = Output.all(values.asList())
    }

    /**
     * @param values Resource tag keys to ignore across all resources. Can also be configured with the TF_AWS_IGNORE_TAGS_KEYS environment variable.
     */
    @JvmName("kmsktllxbxridmel")
    public suspend fun keys(values: List<Output<String>>) {
        this.keys = Output.all(values)
    }

    /**
     * @param value Resource tag key prefixes to ignore across all resources. Can also be configured with the TF_AWS_IGNORE_TAGS_KEY_PREFIXES environment variable.
     */
    @JvmName("jtrghrnyplxpbnhx")
    public suspend fun keyPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPrefixes = mapped
    }

    /**
     * @param values Resource tag key prefixes to ignore across all resources. Can also be configured with the TF_AWS_IGNORE_TAGS_KEY_PREFIXES environment variable.
     */
    @JvmName("wqkskkhtkssqndoj")
    public suspend fun keyPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyPrefixes = mapped
    }

    /**
     * @param value Resource tag keys to ignore across all resources. Can also be configured with the TF_AWS_IGNORE_TAGS_KEYS environment variable.
     */
    @JvmName("datfuqmiwdvtkjms")
    public suspend fun keys(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keys = mapped
    }

    /**
     * @param values Resource tag keys to ignore across all resources. Can also be configured with the TF_AWS_IGNORE_TAGS_KEYS environment variable.
     */
    @JvmName("fumptskhglqossxo")
    public suspend fun keys(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keys = mapped
    }

    internal fun build(): ProviderIgnoreTagsArgs = ProviderIgnoreTagsArgs(
        keyPrefixes = keyPrefixes,
        keys = keys,
    )
}
