@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getArn.
 * @property account The [ID](https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html) of the AWS account that owns the resource, without the hyphens.
 * @property arn
 * @property id
 * @property partition Partition that the resource is in.
 * @property region Region the resource resides in.
 * Note that the ARNs for some resources do not require a region, so this component might be omitted.
 * @property resource Content of this part of the ARN varies by service.
 * It often includes an indicator of the type of resource—for example, an IAM user or Amazon RDS database —followed by a slash (/) or a colon (:), followed by the resource name itself.
 * @property service The [service namespace](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces) that identifies the AWS product.
 */
public data class GetArnResult(
    public val account: String,
    public val arn: String,
    public val id: String,
    public val partition: String,
    public val region: String,
    public val resource: String,
    public val service: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.outputs.GetArnResult): GetArnResult = GetArnResult(
            account = javaType.account(),
            arn = javaType.arn(),
            id = javaType.id(),
            partition = javaType.partition(),
            region = javaType.region(),
            resource = javaType.resource(),
            service = javaType.service(),
        )
    }
}
