@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAvailabilityZone.
 * @property allAvailabilityZones
 * @property filters
 * @property groupName For Availability Zones, this is the same value as the Region name. For Local Zones, the name of the associated group, for example `us-west-2-lax-1`.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property nameSuffix Part of the AZ name that appears after the region name, uniquely identifying the AZ within its region.
 * For Availability Zones this is usually a single letter, for example `a` for the `us-west-2a` zone.
 * For Local and Wavelength Zones this is a longer string, for example `wl1-sfo-wlz-1` for the `us-west-2-wl1-sfo-wlz-1` zone.
 * @property networkBorderGroup The name of the location from which the address is advertised.
 * @property optInStatus For Availability Zones, this always has the value of `opt-in-not-required`. For Local Zones, this is the opt in status. The possible values are `opted-in` and `not-opted-in`.
 * @property parentZoneId ID of the zone that handles some of the Local Zone or Wavelength Zone control plane operations, such as API calls.
 * @property parentZoneName Name of the zone that handles some of the Local Zone or Wavelength Zone control plane operations, such as API calls.
 * @property region Region where the selected availability zone resides. This is always the region selected on the provider, since this data source searches only within that region.
 * @property state
 * @property zoneId
 * @property zoneType Type of zone. Values are `availability-zone`, `local-zone`, and `wavelength-zone`.
 */
public data class GetAvailabilityZoneResult(
    public val allAvailabilityZones: Boolean? = null,
    public val filters: List<GetAvailabilityZoneFilter>? = null,
    public val groupName: String,
    public val id: String,
    public val name: String,
    public val nameSuffix: String,
    public val networkBorderGroup: String,
    public val optInStatus: String,
    public val parentZoneId: String,
    public val parentZoneName: String,
    public val region: String,
    public val state: String,
    public val zoneId: String,
    public val zoneType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.outputs.GetAvailabilityZoneResult): GetAvailabilityZoneResult = GetAvailabilityZoneResult(
            allAvailabilityZones = javaType.allAvailabilityZones().map({ args0 -> args0 }).orElse(null),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kotlin.outputs.GetAvailabilityZoneFilter.Companion.toKotlin(args0)
                })
            }),
            groupName = javaType.groupName(),
            id = javaType.id(),
            name = javaType.name(),
            nameSuffix = javaType.nameSuffix(),
            networkBorderGroup = javaType.networkBorderGroup(),
            optInStatus = javaType.optInStatus(),
            parentZoneId = javaType.parentZoneId(),
            parentZoneName = javaType.parentZoneName(),
            region = javaType.region(),
            state = javaType.state(),
            zoneId = javaType.zoneId(),
            zoneType = javaType.zoneType(),
        )
    }
}
