@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAvailabilityZones.
 * @property allAvailabilityZones
 * @property excludeNames
 * @property excludeZoneIds
 * @property filters
 * @property groupNames A set of the Availability Zone Group names. For Availability Zones, this is the same value as the Region name. For Local Zones, the name of the associated group, for example `us-west-2-lax-1`.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property names List of the Availability Zone names available to the account.
 * @property state
 * @property zoneIds List of the Availability Zone IDs available to the account.
 */
public data class GetAvailabilityZonesResult(
    public val allAvailabilityZones: Boolean? = null,
    public val excludeNames: List<String>? = null,
    public val excludeZoneIds: List<String>? = null,
    public val filters: List<GetAvailabilityZonesFilter>? = null,
    public val groupNames: List<String>,
    public val id: String,
    public val names: List<String>,
    public val state: String? = null,
    public val zoneIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.outputs.GetAvailabilityZonesResult): GetAvailabilityZonesResult = GetAvailabilityZonesResult(
            allAvailabilityZones = javaType.allAvailabilityZones().map({ args0 -> args0 }).orElse(null),
            excludeNames = javaType.excludeNames().map({ args0 -> args0 }),
            excludeZoneIds = javaType.excludeZoneIds().map({ args0 -> args0 }),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kotlin.outputs.GetAvailabilityZonesFilter.Companion.toKotlin(args0)
                })
            }),
            groupNames = javaType.groupNames().map({ args0 -> args0 }),
            id = javaType.id(),
            names = javaType.names().map({ args0 -> args0 }),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            zoneIds = javaType.zoneIds().map({ args0 -> args0 }),
        )
    }
}
