@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getIpRanges.
 * @property cidrBlocks Lexically ordered list of CIDR blocks.
 * @property createDate Publication time of the IP ranges (e.g., `2016-08-03-23-46-05`).
 * @property id
 * @property ipv6CidrBlocks Lexically ordered list of IPv6 CIDR blocks.
 * @property regions
 * @property services
 * @property syncToken Publication time of the IP ranges, in Unix epoch time format
 * (e.g., `1470267965`).
 * @property url
 */
public data class GetIpRangesResult(
    public val cidrBlocks: List<String>,
    public val createDate: String,
    public val id: String,
    public val ipv6CidrBlocks: List<String>,
    public val regions: List<String>? = null,
    public val services: List<String>,
    public val syncToken: Int,
    public val url: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.outputs.GetIpRangesResult): GetIpRangesResult =
            GetIpRangesResult(
                cidrBlocks = javaType.cidrBlocks().map({ args0 -> args0 }),
                createDate = javaType.createDate(),
                id = javaType.id(),
                ipv6CidrBlocks = javaType.ipv6CidrBlocks().map({ args0 -> args0 }),
                regions = javaType.regions().map({ args0 -> args0 }),
                services = javaType.services().map({ args0 -> args0 }),
                syncToken = javaType.syncToken(),
                url = javaType.url().map({ args0 -> args0 }).orElse(null),
            )
    }
}
