@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getPartition.
 * @property dnsSuffix Base DNS domain name for the current partition (e.g., `amazonaws.com` in AWS Commercial, `amazonaws.com.cn` in AWS China).
 * @property id Identifier of the current partition (e.g., `aws` in AWS Commercial, `aws-cn` in AWS China).
 * @property partition Identifier of the current partition (e.g., `aws` in AWS Commercial, `aws-cn` in AWS China).
 * @property reverseDnsPrefix Prefix of service names (e.g., `com.amazonaws` in AWS Commercial, `cn.com.amazonaws` in AWS China).
 */
public data class GetPartitionResult(
    public val dnsSuffix: String,
    public val id: String,
    public val partition: String,
    public val reverseDnsPrefix: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.outputs.GetPartitionResult): GetPartitionResult =
            GetPartitionResult(
                dnsSuffix = javaType.dnsSuffix(),
                id = javaType.id(),
                partition = javaType.partition(),
                reverseDnsPrefix = javaType.reverseDnsPrefix(),
            )
    }
}
