@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property name Name of the filter field. Valid values can be found in the [describe-regions AWS CLI Reference][1].
 * @property values Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
 */
public data class GetRegionsFilter(
    public val name: String,
    public val values: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.outputs.GetRegionsFilter): GetRegionsFilter =
            GetRegionsFilter(
                name = javaType.name(),
                values = javaType.values().map({ args0 -> args0 }),
            )
    }
}
