@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getServicePrincipal.
 * @property id Identifier of the current Service Principal (compound of service, region and suffix). (e.g. `logs.us-east-1.amazonaws.com`in AWS Commercial, `logs.cn-north-1.amazonaws.com.cn` in AWS China).
 * @property name Service Principal Name (e.g., `logs.amazonaws.com` in AWS Commercial, `logs.amazonaws.com.cn` in AWS China).
 * @property region Region identifier of the generated SPN (e.g., `us-east-1` in AWS Commercial, `cn-north-1` in AWS China).
 * @property serviceName
 * @property suffix Suffix of the SPN (e.g., `amazonaws.com` in AWS Commercial, `amazonaws.com.cn` in AWS China).
 */
public data class GetServicePrincipalResult(
    public val id: String,
    public val name: String,
    public val region: String,
    public val serviceName: String,
    public val suffix: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.outputs.GetServicePrincipalResult): GetServicePrincipalResult = GetServicePrincipalResult(
            id = javaType.id(),
            name = javaType.name(),
            region = javaType.region(),
            serviceName = javaType.serviceName(),
            suffix = javaType.suffix(),
        )
    }
}
