@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin

import com.pulumi.aws.lakeformation.kotlin.outputs.DataCellsFilterTableData
import com.pulumi.aws.lakeformation.kotlin.outputs.DataCellsFilterTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.lakeformation.kotlin.outputs.DataCellsFilterTableData.Companion.toKotlin as dataCellsFilterTableDataToKotlin
import com.pulumi.aws.lakeformation.kotlin.outputs.DataCellsFilterTimeouts.Companion.toKotlin as dataCellsFilterTimeoutsToKotlin

/**
 * Builder for [DataCellsFilter].
 */
@PulumiTagMarker
public class DataCellsFilterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataCellsFilterArgs = DataCellsFilterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataCellsFilterArgsBuilder.() -> Unit) {
        val builder = DataCellsFilterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DataCellsFilter {
        val builtJavaResource = com.pulumi.aws.lakeformation.DataCellsFilter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DataCellsFilter(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Lake Formation Data Cells Filter.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lakeformation.DataCellsFilter("example", {tableData: {
 *     databaseName: test.name,
 *     name: "example",
 *     tableCatalogId: current.accountId,
 *     tableName: testAwsGlueCatalogTable.name,
 *     columnNames: ["my_column"],
 *     rowFilter: {
 *         filterExpression: "my_column='example'",
 *     },
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lakeformation.DataCellsFilter("example", table_data={
 *     "database_name": test["name"],
 *     "name": "example",
 *     "table_catalog_id": current["accountId"],
 *     "table_name": test_aws_glue_catalog_table["name"],
 *     "column_names": ["my_column"],
 *     "row_filter": {
 *         "filter_expression": "my_column='example'",
 *     },
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.LakeFormation.DataCellsFilter("example", new()
 *     {
 *         TableData = new Aws.LakeFormation.Inputs.DataCellsFilterTableDataArgs
 *         {
 *             DatabaseName = test.Name,
 *             Name = "example",
 *             TableCatalogId = current.AccountId,
 *             TableName = testAwsGlueCatalogTable.Name,
 *             ColumnNames = new[]
 *             {
 *                 "my_column",
 *             },
 *             RowFilter = new Aws.LakeFormation.Inputs.DataCellsFilterTableDataRowFilterArgs
 *             {
 *                 FilterExpression = "my_column='example'",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lakeformation"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lakeformation.NewDataCellsFilter(ctx, "example", &lakeformation.DataCellsFilterArgs{
 * 			TableData: &lakeformation.DataCellsFilterTableDataArgs{
 * 				DatabaseName:   pulumi.Any(test.Name),
 * 				Name:           pulumi.String("example"),
 * 				TableCatalogId: pulumi.Any(current.AccountId),
 * 				TableName:      pulumi.Any(testAwsGlueCatalogTable.Name),
 * 				ColumnNames: pulumi.StringArray{
 * 					pulumi.String("my_column"),
 * 				},
 * 				RowFilter: &lakeformation.DataCellsFilterTableDataRowFilterArgs{
 * 					FilterExpression: pulumi.String("my_column='example'"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.DataCellsFilter;
 * import com.pulumi.aws.lakeformation.DataCellsFilterArgs;
 * import com.pulumi.aws.lakeformation.inputs.DataCellsFilterTableDataArgs;
 * import com.pulumi.aws.lakeformation.inputs.DataCellsFilterTableDataRowFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataCellsFilter("example", DataCellsFilterArgs.builder()
 *             .tableData(DataCellsFilterTableDataArgs.builder()
 *                 .databaseName(test.name())
 *                 .name("example")
 *                 .tableCatalogId(current.accountId())
 *                 .tableName(testAwsGlueCatalogTable.name())
 *                 .columnNames("my_column")
 *                 .rowFilter(DataCellsFilterTableDataRowFilterArgs.builder()
 *                     .filterExpression("my_column='example'")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lakeformation:DataCellsFilter
 *     properties:
 *       tableData:
 *         databaseName: ${test.name}
 *         name: example
 *         tableCatalogId: ${current.accountId}
 *         tableName: ${testAwsGlueCatalogTable.name}
 *         columnNames:
 *           - my_column
 *         rowFilter:
 *           filterExpression: my_column='example'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Lake Formation Data Cells Filter using the `id`. For example:
 * ```sh
 * $ pulumi import aws:lakeformation/dataCellsFilter:DataCellsFilter example database_name,name,table_catalog_id,table_name
 * ```
 */
public class DataCellsFilter internal constructor(
    override val javaResource: com.pulumi.aws.lakeformation.DataCellsFilter,
) : KotlinCustomResource(javaResource, DataCellsFilterMapper) {
    /**
     * Information about the data cells filter. See Table Data below for details.
     */
    public val tableData: Output<DataCellsFilterTableData>?
        get() = javaResource.tableData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dataCellsFilterTableDataToKotlin(args0)
                })
            }).orElse(null)
        })

    public val timeouts: Output<DataCellsFilterTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dataCellsFilterTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object DataCellsFilterMapper : ResourceMapper<DataCellsFilter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lakeformation.DataCellsFilter::class == javaResource::class

    override fun map(javaResource: Resource): DataCellsFilter = DataCellsFilter(
        javaResource as
            com.pulumi.aws.lakeformation.DataCellsFilter,
    )
}

/**
 * @see [DataCellsFilter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataCellsFilter].
 */
public suspend fun dataCellsFilter(
    name: String,
    block: suspend DataCellsFilterResourceBuilder.() -> Unit,
): DataCellsFilter {
    val builder = DataCellsFilterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataCellsFilter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataCellsFilter(name: String): DataCellsFilter {
    val builder = DataCellsFilterResourceBuilder()
    builder.name(name)
    return builder.build()
}
