@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin

import com.pulumi.aws.lakeformation.DataCellsFilterArgs.builder
import com.pulumi.aws.lakeformation.kotlin.inputs.DataCellsFilterTableDataArgs
import com.pulumi.aws.lakeformation.kotlin.inputs.DataCellsFilterTableDataArgsBuilder
import com.pulumi.aws.lakeformation.kotlin.inputs.DataCellsFilterTimeoutsArgs
import com.pulumi.aws.lakeformation.kotlin.inputs.DataCellsFilterTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Lake Formation Data Cells Filter.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lakeformation.DataCellsFilter("example", {tableData: {
 *     databaseName: test.name,
 *     name: "example",
 *     tableCatalogId: current.accountId,
 *     tableName: testAwsGlueCatalogTable.name,
 *     columnNames: ["my_column"],
 *     rowFilter: {
 *         filterExpression: "my_column='example'",
 *     },
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lakeformation.DataCellsFilter("example", table_data={
 *     "database_name": test["name"],
 *     "name": "example",
 *     "table_catalog_id": current["accountId"],
 *     "table_name": test_aws_glue_catalog_table["name"],
 *     "column_names": ["my_column"],
 *     "row_filter": {
 *         "filter_expression": "my_column='example'",
 *     },
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.LakeFormation.DataCellsFilter("example", new()
 *     {
 *         TableData = new Aws.LakeFormation.Inputs.DataCellsFilterTableDataArgs
 *         {
 *             DatabaseName = test.Name,
 *             Name = "example",
 *             TableCatalogId = current.AccountId,
 *             TableName = testAwsGlueCatalogTable.Name,
 *             ColumnNames = new[]
 *             {
 *                 "my_column",
 *             },
 *             RowFilter = new Aws.LakeFormation.Inputs.DataCellsFilterTableDataRowFilterArgs
 *             {
 *                 FilterExpression = "my_column='example'",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lakeformation"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lakeformation.NewDataCellsFilter(ctx, "example", &lakeformation.DataCellsFilterArgs{
 * 			TableData: &lakeformation.DataCellsFilterTableDataArgs{
 * 				DatabaseName:   pulumi.Any(test.Name),
 * 				Name:           pulumi.String("example"),
 * 				TableCatalogId: pulumi.Any(current.AccountId),
 * 				TableName:      pulumi.Any(testAwsGlueCatalogTable.Name),
 * 				ColumnNames: pulumi.StringArray{
 * 					pulumi.String("my_column"),
 * 				},
 * 				RowFilter: &lakeformation.DataCellsFilterTableDataRowFilterArgs{
 * 					FilterExpression: pulumi.String("my_column='example'"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.DataCellsFilter;
 * import com.pulumi.aws.lakeformation.DataCellsFilterArgs;
 * import com.pulumi.aws.lakeformation.inputs.DataCellsFilterTableDataArgs;
 * import com.pulumi.aws.lakeformation.inputs.DataCellsFilterTableDataRowFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataCellsFilter("example", DataCellsFilterArgs.builder()
 *             .tableData(DataCellsFilterTableDataArgs.builder()
 *                 .databaseName(test.name())
 *                 .name("example")
 *                 .tableCatalogId(current.accountId())
 *                 .tableName(testAwsGlueCatalogTable.name())
 *                 .columnNames("my_column")
 *                 .rowFilter(DataCellsFilterTableDataRowFilterArgs.builder()
 *                     .filterExpression("my_column='example'")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lakeformation:DataCellsFilter
 *     properties:
 *       tableData:
 *         databaseName: ${test.name}
 *         name: example
 *         tableCatalogId: ${current.accountId}
 *         tableName: ${testAwsGlueCatalogTable.name}
 *         columnNames:
 *           - my_column
 *         rowFilter:
 *           filterExpression: my_column='example'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Lake Formation Data Cells Filter using the `id`. For example:
 * ```sh
 * $ pulumi import aws:lakeformation/dataCellsFilter:DataCellsFilter example database_name,name,table_catalog_id,table_name
 * ```
 * @property tableData Information about the data cells filter. See Table Data below for details.
 * @property timeouts
 */
public data class DataCellsFilterArgs(
    public val tableData: Output<DataCellsFilterTableDataArgs>? = null,
    public val timeouts: Output<DataCellsFilterTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.DataCellsFilterArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.DataCellsFilterArgs =
        com.pulumi.aws.lakeformation.DataCellsFilterArgs.builder()
            .tableData(tableData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataCellsFilterArgs].
 */
@PulumiTagMarker
public class DataCellsFilterArgsBuilder internal constructor() {
    private var tableData: Output<DataCellsFilterTableDataArgs>? = null

    private var timeouts: Output<DataCellsFilterTimeoutsArgs>? = null

    /**
     * @param value Information about the data cells filter. See Table Data below for details.
     */
    @JvmName("dynarfvxghqhpnft")
    public suspend fun tableData(`value`: Output<DataCellsFilterTableDataArgs>) {
        this.tableData = value
    }

    /**
     * @param value
     */
    @JvmName("mmrpsvhyrhseigop")
    public suspend fun timeouts(`value`: Output<DataCellsFilterTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Information about the data cells filter. See Table Data below for details.
     */
    @JvmName("nxgserxptwaplyku")
    public suspend fun tableData(`value`: DataCellsFilterTableDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableData = mapped
    }

    /**
     * @param argument Information about the data cells filter. See Table Data below for details.
     */
    @JvmName("lcoggnainuvkcaqm")
    public suspend fun tableData(argument: suspend DataCellsFilterTableDataArgsBuilder.() -> Unit) {
        val toBeMapped = DataCellsFilterTableDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tableData = mapped
    }

    /**
     * @param value
     */
    @JvmName("ylrpbqgecfnscgal")
    public suspend fun timeouts(`value`: DataCellsFilterTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("smfeecdnukqjxuan")
    public suspend fun timeouts(argument: suspend DataCellsFilterTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = DataCellsFilterTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): DataCellsFilterArgs = DataCellsFilterArgs(
        tableData = tableData,
        timeouts = timeouts,
    )
}
