@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin

import com.pulumi.aws.lakeformation.DataLakeSettingsArgs.builder
import com.pulumi.aws.lakeformation.kotlin.inputs.DataLakeSettingsCreateDatabaseDefaultPermissionArgs
import com.pulumi.aws.lakeformation.kotlin.inputs.DataLakeSettingsCreateDatabaseDefaultPermissionArgsBuilder
import com.pulumi.aws.lakeformation.kotlin.inputs.DataLakeSettingsCreateTableDefaultPermissionArgs
import com.pulumi.aws.lakeformation.kotlin.inputs.DataLakeSettingsCreateTableDefaultPermissionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Manages Lake Formation principals designated as data lake administrators and lists of principal permission entries for default create database and default create table permissions.
 * > **NOTE:** Lake Formation introduces fine-grained access control for data in your data lake. Part of the changes include the `IAMAllowedPrincipals` principal in order to make Lake Formation backwards compatible with existing IAM and Glue permissions. For more information, see [Changing the Default Security Settings for Your Data Lake](https://docs&#46;aws&#46;amazon&#46;com/lake-formation/latest/dg/change-settings&#46;html) and [Upgrading AWS Glue Data Permissions to the AWS Lake Formation Model](https://docs.aws.amazon.com/lake-formation/latest/dg/upgrade-glue-lake-formation.html).
 * ## Example Usage
 * ### Data Lake Admins
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lakeformation.DataLakeSettings("example", {admins: [
 *     test.arn,
 *     testAwsIamRole.arn,
 * ]});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lakeformation.DataLakeSettings("example", admins=[
 *     test["arn"],
 *     test_aws_iam_role["arn"],
 * ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.LakeFormation.DataLakeSettings("example", new()
 *     {
 *         Admins = new[]
 *         {
 *             test.Arn,
 *             testAwsIamRole.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lakeformation"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lakeformation.NewDataLakeSettings(ctx, "example", &lakeformation.DataLakeSettingsArgs{
 * 			Admins: pulumi.StringArray{
 * 				test.Arn,
 * 				testAwsIamRole.Arn,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.DataLakeSettings;
 * import com.pulumi.aws.lakeformation.DataLakeSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataLakeSettings("example", DataLakeSettingsArgs.builder()
 *             .admins(
 *                 test.arn(),
 *                 testAwsIamRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lakeformation:DataLakeSettings
 *     properties:
 *       admins:
 *         - ${test.arn}
 *         - ${testAwsIamRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Create Default Permissions
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lakeformation.DataLakeSettings("example", {
 *     admins: [
 *         test.arn,
 *         testAwsIamRole.arn,
 *     ],
 *     createDatabaseDefaultPermissions: [{
 *         permissions: [
 *             "SELECT",
 *             "ALTER",
 *             "DROP",
 *         ],
 *         principal: test.arn,
 *     }],
 *     createTableDefaultPermissions: [{
 *         permissions: ["ALL"],
 *         principal: testAwsIamRole.arn,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lakeformation.DataLakeSettings("example",
 *     admins=[
 *         test["arn"],
 *         test_aws_iam_role["arn"],
 *     ],
 *     create_database_default_permissions=[{
 *         "permissions": [
 *             "SELECT",
 *             "ALTER",
 *             "DROP",
 *         ],
 *         "principal": test["arn"],
 *     }],
 *     create_table_default_permissions=[{
 *         "permissions": ["ALL"],
 *         "principal": test_aws_iam_role["arn"],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.LakeFormation.DataLakeSettings("example", new()
 *     {
 *         Admins = new[]
 *         {
 *             test.Arn,
 *             testAwsIamRole.Arn,
 *         },
 *         CreateDatabaseDefaultPermissions = new[]
 *         {
 *             new Aws.LakeFormation.Inputs.DataLakeSettingsCreateDatabaseDefaultPermissionArgs
 *             {
 *                 Permissions = new[]
 *                 {
 *                     "SELECT",
 *                     "ALTER",
 *                     "DROP",
 *                 },
 *                 Principal = test.Arn,
 *             },
 *         },
 *         CreateTableDefaultPermissions = new[]
 *         {
 *             new Aws.LakeFormation.Inputs.DataLakeSettingsCreateTableDefaultPermissionArgs
 *             {
 *                 Permissions = new[]
 *                 {
 *                     "ALL",
 *                 },
 *                 Principal = testAwsIamRole.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lakeformation"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lakeformation.NewDataLakeSettings(ctx, "example", &lakeformation.DataLakeSettingsArgs{
 * 			Admins: pulumi.StringArray{
 * 				test.Arn,
 * 				testAwsIamRole.Arn,
 * 			},
 * 			CreateDatabaseDefaultPermissions: lakeformation.DataLakeSettingsCreateDatabaseDefaultPermissionArray{
 * 				&lakeformation.DataLakeSettingsCreateDatabaseDefaultPermissionArgs{
 * 					Permissions: pulumi.StringArray{
 * 						pulumi.String("SELECT"),
 * 						pulumi.String("ALTER"),
 * 						pulumi.String("DROP"),
 * 					},
 * 					Principal: pulumi.Any(test.Arn),
 * 				},
 * 			},
 * 			CreateTableDefaultPermissions: lakeformation.DataLakeSettingsCreateTableDefaultPermissionArray{
 * 				&lakeformation.DataLakeSettingsCreateTableDefaultPermissionArgs{
 * 					Permissions: pulumi.StringArray{
 * 						pulumi.String("ALL"),
 * 					},
 * 					Principal: pulumi.Any(testAwsIamRole.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.DataLakeSettings;
 * import com.pulumi.aws.lakeformation.DataLakeSettingsArgs;
 * import com.pulumi.aws.lakeformation.inputs.DataLakeSettingsCreateDatabaseDefaultPermissionArgs;
 * import com.pulumi.aws.lakeformation.inputs.DataLakeSettingsCreateTableDefaultPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataLakeSettings("example", DataLakeSettingsArgs.builder()
 *             .admins(
 *                 test.arn(),
 *                 testAwsIamRole.arn())
 *             .createDatabaseDefaultPermissions(DataLakeSettingsCreateDatabaseDefaultPermissionArgs.builder()
 *                 .permissions(
 *                     "SELECT",
 *                     "ALTER",
 *                     "DROP")
 *                 .principal(test.arn())
 *                 .build())
 *             .createTableDefaultPermissions(DataLakeSettingsCreateTableDefaultPermissionArgs.builder()
 *                 .permissions("ALL")
 *                 .principal(testAwsIamRole.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lakeformation:DataLakeSettings
 *     properties:
 *       admins:
 *         - ${test.arn}
 *         - ${testAwsIamRole.arn}
 *       createDatabaseDefaultPermissions:
 *         - permissions:
 *             - SELECT
 *             - ALTER
 *             - DROP
 *           principal: ${test.arn}
 *       createTableDefaultPermissions:
 *         - permissions:
 *             - ALL
 *           principal: ${testAwsIamRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Enable EMR access to LakeFormation resources
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lakeformation.DataLakeSettings("example", {
 *     admins: [
 *         test.arn,
 *         testAwsIamRole.arn,
 *     ],
 *     createDatabaseDefaultPermissions: [{
 *         permissions: [
 *             "SELECT",
 *             "ALTER",
 *             "DROP",
 *         ],
 *         principal: test.arn,
 *     }],
 *     createTableDefaultPermissions: [{
 *         permissions: ["ALL"],
 *         principal: testAwsIamRole.arn,
 *     }],
 *     allowExternalDataFiltering: true,
 *     externalDataFilteringAllowLists: [
 *         current.accountId,
 *         thirdParty.accountId,
 *     ],
 *     authorizedSessionTagValueLists: ["Amazon EMR"],
 *     allowFullTableExternalDataAccess: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lakeformation.DataLakeSettings("example",
 *     admins=[
 *         test["arn"],
 *         test_aws_iam_role["arn"],
 *     ],
 *     create_database_default_permissions=[{
 *         "permissions": [
 *             "SELECT",
 *             "ALTER",
 *             "DROP",
 *         ],
 *         "principal": test["arn"],
 *     }],
 *     create_table_default_permissions=[{
 *         "permissions": ["ALL"],
 *         "principal": test_aws_iam_role["arn"],
 *     }],
 *     allow_external_data_filtering=True,
 *     external_data_filtering_allow_lists=[
 *         current["accountId"],
 *         third_party["accountId"],
 *     ],
 *     authorized_session_tag_value_lists=["Amazon EMR"],
 *     allow_full_table_external_data_access=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.LakeFormation.DataLakeSettings("example", new()
 *     {
 *         Admins = new[]
 *         {
 *             test.Arn,
 *             testAwsIamRole.Arn,
 *         },
 *         CreateDatabaseDefaultPermissions = new[]
 *         {
 *             new Aws.LakeFormation.Inputs.DataLakeSettingsCreateDatabaseDefaultPermissionArgs
 *             {
 *                 Permissions = new[]
 *                 {
 *                     "SELECT",
 *                     "ALTER",
 *                     "DROP",
 *                 },
 *                 Principal = test.Arn,
 *             },
 *         },
 *         CreateTableDefaultPermissions = new[]
 *         {
 *             new Aws.LakeFormation.Inputs.DataLakeSettingsCreateTableDefaultPermissionArgs
 *             {
 *                 Permissions = new[]
 *                 {
 *                     "ALL",
 *                 },
 *                 Principal = testAwsIamRole.Arn,
 *             },
 *         },
 *         AllowExternalDataFiltering = true,
 *         ExternalDataFilteringAllowLists = new[]
 *         {
 *             current.AccountId,
 *             thirdParty.AccountId,
 *         },
 *         AuthorizedSessionTagValueLists = new[]
 *         {
 *             "Amazon EMR",
 *         },
 *         AllowFullTableExternalDataAccess = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lakeformation"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lakeformation.NewDataLakeSettings(ctx, "example", &lakeformation.DataLakeSettingsArgs{
 * 			Admins: pulumi.StringArray{
 * 				test.Arn,
 * 				testAwsIamRole.Arn,
 * 			},
 * 			CreateDatabaseDefaultPermissions: lakeformation.DataLakeSettingsCreateDatabaseDefaultPermissionArray{
 * 				&lakeformation.DataLakeSettingsCreateDatabaseDefaultPermissionArgs{
 * 					Permissions: pulumi.StringArray{
 * 						pulumi.String("SELECT"),
 * 						pulumi.String("ALTER"),
 * 						pulumi.String("DROP"),
 * 					},
 * 					Principal: pulumi.Any(test.Arn),
 * 				},
 * 			},
 * 			CreateTableDefaultPermissions: lakeformation.DataLakeSettingsCreateTableDefaultPermissionArray{
 * 				&lakeformation.DataLakeSettingsCreateTableDefaultPermissionArgs{
 * 					Permissions: pulumi.StringArray{
 * 						pulumi.String("ALL"),
 * 					},
 * 					Principal: pulumi.Any(testAwsIamRole.Arn),
 * 				},
 * 			},
 * 			AllowExternalDataFiltering: pulumi.Bool(true),
 * 			ExternalDataFilteringAllowLists: pulumi.StringArray{
 * 				current.AccountId,
 * 				thirdParty.AccountId,
 * 			},
 * 			AuthorizedSessionTagValueLists: pulumi.StringArray{
 * 				pulumi.String("Amazon EMR"),
 * 			},
 * 			AllowFullTableExternalDataAccess: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.DataLakeSettings;
 * import com.pulumi.aws.lakeformation.DataLakeSettingsArgs;
 * import com.pulumi.aws.lakeformation.inputs.DataLakeSettingsCreateDatabaseDefaultPermissionArgs;
 * import com.pulumi.aws.lakeformation.inputs.DataLakeSettingsCreateTableDefaultPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataLakeSettings("example", DataLakeSettingsArgs.builder()
 *             .admins(
 *                 test.arn(),
 *                 testAwsIamRole.arn())
 *             .createDatabaseDefaultPermissions(DataLakeSettingsCreateDatabaseDefaultPermissionArgs.builder()
 *                 .permissions(
 *                     "SELECT",
 *                     "ALTER",
 *                     "DROP")
 *                 .principal(test.arn())
 *                 .build())
 *             .createTableDefaultPermissions(DataLakeSettingsCreateTableDefaultPermissionArgs.builder()
 *                 .permissions("ALL")
 *                 .principal(testAwsIamRole.arn())
 *                 .build())
 *             .allowExternalDataFiltering(true)
 *             .externalDataFilteringAllowLists(
 *                 current.accountId(),
 *                 thirdParty.accountId())
 *             .authorizedSessionTagValueLists("Amazon EMR")
 *             .allowFullTableExternalDataAccess(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lakeformation:DataLakeSettings
 *     properties:
 *       admins:
 *         - ${test.arn}
 *         - ${testAwsIamRole.arn}
 *       createDatabaseDefaultPermissions:
 *         - permissions:
 *             - SELECT
 *             - ALTER
 *             - DROP
 *           principal: ${test.arn}
 *       createTableDefaultPermissions:
 *         - permissions:
 *             - ALL
 *           principal: ${testAwsIamRole.arn}
 *       allowExternalDataFiltering: true
 *       externalDataFilteringAllowLists:
 *         - ${current.accountId}
 *         - ${thirdParty.accountId}
 *       authorizedSessionTagValueLists:
 *         - Amazon EMR
 *       allowFullTableExternalDataAccess: true
 * ```
 * <!--End PulumiCodeChooser -->
 * @property admins Set of ARNs of AWS Lake Formation principals (IAM users or roles).
 * @property allowExternalDataFiltering Whether to allow Amazon EMR clusters to access data managed by Lake Formation.
 * @property allowFullTableExternalDataAccess Whether to allow a third-party query engine to get data access credentials without session tags when a caller has full data access permissions.
 * > **NOTE:** Although optional, not including `admins`, `create_database_default_permissions`, `create_table_default_permissions`, and/or `trusted_resource_owners` results in the setting being cleared.
 * @property authorizedSessionTagValueLists Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
 * @property catalogId Identifier for the Data Catalog. By default, the account ID.
 * @property createDatabaseDefaultPermissions Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
 * @property createTableDefaultPermissions Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
 * @property externalDataFilteringAllowLists A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.
 * @property readOnlyAdmins Set of ARNs of AWS Lake Formation principals (IAM users or roles) with only view access to the resources.
 * @property trustedResourceOwners List of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs).
 */
public data class DataLakeSettingsArgs(
    public val admins: Output<List<String>>? = null,
    public val allowExternalDataFiltering: Output<Boolean>? = null,
    public val allowFullTableExternalDataAccess: Output<Boolean>? = null,
    public val authorizedSessionTagValueLists: Output<List<String>>? = null,
    public val catalogId: Output<String>? = null,
    public val createDatabaseDefaultPermissions: Output<List<DataLakeSettingsCreateDatabaseDefaultPermissionArgs>>? = null,
    public val createTableDefaultPermissions: Output<List<DataLakeSettingsCreateTableDefaultPermissionArgs>>? = null,
    public val externalDataFilteringAllowLists: Output<List<String>>? = null,
    public val readOnlyAdmins: Output<List<String>>? = null,
    public val trustedResourceOwners: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.DataLakeSettingsArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.DataLakeSettingsArgs =
        com.pulumi.aws.lakeformation.DataLakeSettingsArgs.builder()
            .admins(admins?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowExternalDataFiltering(allowExternalDataFiltering?.applyValue({ args0 -> args0 }))
            .allowFullTableExternalDataAccess(allowFullTableExternalDataAccess?.applyValue({ args0 -> args0 }))
            .authorizedSessionTagValueLists(
                authorizedSessionTagValueLists?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .createDatabaseDefaultPermissions(
                createDatabaseDefaultPermissions?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .createTableDefaultPermissions(
                createTableDefaultPermissions?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .externalDataFilteringAllowLists(
                externalDataFilteringAllowLists?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .readOnlyAdmins(readOnlyAdmins?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .trustedResourceOwners(
                trustedResourceOwners?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [DataLakeSettingsArgs].
 */
@PulumiTagMarker
public class DataLakeSettingsArgsBuilder internal constructor() {
    private var admins: Output<List<String>>? = null

    private var allowExternalDataFiltering: Output<Boolean>? = null

    private var allowFullTableExternalDataAccess: Output<Boolean>? = null

    private var authorizedSessionTagValueLists: Output<List<String>>? = null

    private var catalogId: Output<String>? = null

    private var createDatabaseDefaultPermissions:
        Output<List<DataLakeSettingsCreateDatabaseDefaultPermissionArgs>>? = null

    private var createTableDefaultPermissions:
        Output<List<DataLakeSettingsCreateTableDefaultPermissionArgs>>? = null

    private var externalDataFilteringAllowLists: Output<List<String>>? = null

    private var readOnlyAdmins: Output<List<String>>? = null

    private var trustedResourceOwners: Output<List<String>>? = null

    /**
     * @param value Set of ARNs of AWS Lake Formation principals (IAM users or roles).
     */
    @JvmName("vkatvjsoeitewpps")
    public suspend fun admins(`value`: Output<List<String>>) {
        this.admins = value
    }

    @JvmName("vdnvdyqbugnfmwbx")
    public suspend fun admins(vararg values: Output<String>) {
        this.admins = Output.all(values.asList())
    }

    /**
     * @param values Set of ARNs of AWS Lake Formation principals (IAM users or roles).
     */
    @JvmName("kwyoiegyfighdmsw")
    public suspend fun admins(values: List<Output<String>>) {
        this.admins = Output.all(values)
    }

    /**
     * @param value Whether to allow Amazon EMR clusters to access data managed by Lake Formation.
     */
    @JvmName("yphgalieelvodgwn")
    public suspend fun allowExternalDataFiltering(`value`: Output<Boolean>) {
        this.allowExternalDataFiltering = value
    }

    /**
     * @param value Whether to allow a third-party query engine to get data access credentials without session tags when a caller has full data access permissions.
     * > **NOTE:** Although optional, not including `admins`, `create_database_default_permissions`, `create_table_default_permissions`, and/or `trusted_resource_owners` results in the setting being cleared.
     */
    @JvmName("mnlgyqifsvlvgixy")
    public suspend fun allowFullTableExternalDataAccess(`value`: Output<Boolean>) {
        this.allowFullTableExternalDataAccess = value
    }

    /**
     * @param value Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
     */
    @JvmName("emvfummexbmahepg")
    public suspend fun authorizedSessionTagValueLists(`value`: Output<List<String>>) {
        this.authorizedSessionTagValueLists = value
    }

    @JvmName("fvcdlmrpquocsnyf")
    public suspend fun authorizedSessionTagValueLists(vararg values: Output<String>) {
        this.authorizedSessionTagValueLists = Output.all(values.asList())
    }

    /**
     * @param values Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
     */
    @JvmName("sqmbesidyoiugrpe")
    public suspend fun authorizedSessionTagValueLists(values: List<Output<String>>) {
        this.authorizedSessionTagValueLists = Output.all(values)
    }

    /**
     * @param value Identifier for the Data Catalog. By default, the account ID.
     */
    @JvmName("iiywomoygjlypoqj")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
     */
    @JvmName("tekodovsusjcxlvb")
    public suspend fun createDatabaseDefaultPermissions(`value`: Output<List<DataLakeSettingsCreateDatabaseDefaultPermissionArgs>>) {
        this.createDatabaseDefaultPermissions = value
    }

    @JvmName("aipcbvvggkcowqqq")
    public suspend fun createDatabaseDefaultPermissions(vararg values: Output<DataLakeSettingsCreateDatabaseDefaultPermissionArgs>) {
        this.createDatabaseDefaultPermissions = Output.all(values.asList())
    }

    /**
     * @param values Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
     */
    @JvmName("surpunbcfojxjiaq")
    public suspend fun createDatabaseDefaultPermissions(values: List<Output<DataLakeSettingsCreateDatabaseDefaultPermissionArgs>>) {
        this.createDatabaseDefaultPermissions = Output.all(values)
    }

    /**
     * @param value Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
     */
    @JvmName("iecynbxmulyiintu")
    public suspend fun createTableDefaultPermissions(`value`: Output<List<DataLakeSettingsCreateTableDefaultPermissionArgs>>) {
        this.createTableDefaultPermissions = value
    }

    @JvmName("klvjpxjnkwoanomw")
    public suspend fun createTableDefaultPermissions(vararg values: Output<DataLakeSettingsCreateTableDefaultPermissionArgs>) {
        this.createTableDefaultPermissions = Output.all(values.asList())
    }

    /**
     * @param values Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
     */
    @JvmName("rrumwrlqpwhqivgp")
    public suspend fun createTableDefaultPermissions(values: List<Output<DataLakeSettingsCreateTableDefaultPermissionArgs>>) {
        this.createTableDefaultPermissions = Output.all(values)
    }

    /**
     * @param value A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.
     */
    @JvmName("wtkvgwywxyxrkkej")
    public suspend fun externalDataFilteringAllowLists(`value`: Output<List<String>>) {
        this.externalDataFilteringAllowLists = value
    }

    @JvmName("slgqiqbnsmcelpnu")
    public suspend fun externalDataFilteringAllowLists(vararg values: Output<String>) {
        this.externalDataFilteringAllowLists = Output.all(values.asList())
    }

    /**
     * @param values A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.
     */
    @JvmName("hjkryonfnbcqesrx")
    public suspend fun externalDataFilteringAllowLists(values: List<Output<String>>) {
        this.externalDataFilteringAllowLists = Output.all(values)
    }

    /**
     * @param value Set of ARNs of AWS Lake Formation principals (IAM users or roles) with only view access to the resources.
     */
    @JvmName("mfrsuacxdgtielxi")
    public suspend fun readOnlyAdmins(`value`: Output<List<String>>) {
        this.readOnlyAdmins = value
    }

    @JvmName("yfnnultodcfnfpql")
    public suspend fun readOnlyAdmins(vararg values: Output<String>) {
        this.readOnlyAdmins = Output.all(values.asList())
    }

    /**
     * @param values Set of ARNs of AWS Lake Formation principals (IAM users or roles) with only view access to the resources.
     */
    @JvmName("ukgqlawfvuxbbegl")
    public suspend fun readOnlyAdmins(values: List<Output<String>>) {
        this.readOnlyAdmins = Output.all(values)
    }

    /**
     * @param value List of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs).
     */
    @JvmName("jkpsqovdmsucidry")
    public suspend fun trustedResourceOwners(`value`: Output<List<String>>) {
        this.trustedResourceOwners = value
    }

    @JvmName("iwuqehxuslpahqti")
    public suspend fun trustedResourceOwners(vararg values: Output<String>) {
        this.trustedResourceOwners = Output.all(values.asList())
    }

    /**
     * @param values List of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs).
     */
    @JvmName("xncsvqhvioxqshwm")
    public suspend fun trustedResourceOwners(values: List<Output<String>>) {
        this.trustedResourceOwners = Output.all(values)
    }

    /**
     * @param value Set of ARNs of AWS Lake Formation principals (IAM users or roles).
     */
    @JvmName("lmppfpfnvaufpweu")
    public suspend fun admins(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.admins = mapped
    }

    /**
     * @param values Set of ARNs of AWS Lake Formation principals (IAM users or roles).
     */
    @JvmName("aasfhmijwoooestl")
    public suspend fun admins(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.admins = mapped
    }

    /**
     * @param value Whether to allow Amazon EMR clusters to access data managed by Lake Formation.
     */
    @JvmName("ywodmmlhckmsyorj")
    public suspend fun allowExternalDataFiltering(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowExternalDataFiltering = mapped
    }

    /**
     * @param value Whether to allow a third-party query engine to get data access credentials without session tags when a caller has full data access permissions.
     * > **NOTE:** Although optional, not including `admins`, `create_database_default_permissions`, `create_table_default_permissions`, and/or `trusted_resource_owners` results in the setting being cleared.
     */
    @JvmName("wtgsuenwfycsfwii")
    public suspend fun allowFullTableExternalDataAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowFullTableExternalDataAccess = mapped
    }

    /**
     * @param value Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
     */
    @JvmName("nyjrspjldnvubqpk")
    public suspend fun authorizedSessionTagValueLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizedSessionTagValueLists = mapped
    }

    /**
     * @param values Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
     */
    @JvmName("ctxlltgmvhvflwla")
    public suspend fun authorizedSessionTagValueLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizedSessionTagValueLists = mapped
    }

    /**
     * @param value Identifier for the Data Catalog. By default, the account ID.
     */
    @JvmName("okkoelucyesrsyol")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
     */
    @JvmName("tlbavuksksqcxqfu")
    public suspend fun createDatabaseDefaultPermissions(`value`: List<DataLakeSettingsCreateDatabaseDefaultPermissionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createDatabaseDefaultPermissions = mapped
    }

    /**
     * @param argument Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
     */
    @JvmName("ecutxtdugvslusco")
    public suspend fun createDatabaseDefaultPermissions(argument: List<suspend DataLakeSettingsCreateDatabaseDefaultPermissionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataLakeSettingsCreateDatabaseDefaultPermissionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.createDatabaseDefaultPermissions = mapped
    }

    /**
     * @param argument Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
     */
    @JvmName("jpnsgdpyynqafcxt")
    public suspend fun createDatabaseDefaultPermissions(vararg argument: suspend DataLakeSettingsCreateDatabaseDefaultPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataLakeSettingsCreateDatabaseDefaultPermissionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.createDatabaseDefaultPermissions = mapped
    }

    /**
     * @param argument Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
     */
    @JvmName("liyowywswmvngfoa")
    public suspend fun createDatabaseDefaultPermissions(argument: suspend DataLakeSettingsCreateDatabaseDefaultPermissionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DataLakeSettingsCreateDatabaseDefaultPermissionArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.createDatabaseDefaultPermissions = mapped
    }

    /**
     * @param values Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
     */
    @JvmName("vjrmofdyglujtoci")
    public suspend fun createDatabaseDefaultPermissions(vararg values: DataLakeSettingsCreateDatabaseDefaultPermissionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createDatabaseDefaultPermissions = mapped
    }

    /**
     * @param value Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
     */
    @JvmName("djysirjbveqrfiqo")
    public suspend fun createTableDefaultPermissions(`value`: List<DataLakeSettingsCreateTableDefaultPermissionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createTableDefaultPermissions = mapped
    }

    /**
     * @param argument Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
     */
    @JvmName("thvfkjktauyyvreg")
    public suspend fun createTableDefaultPermissions(argument: List<suspend DataLakeSettingsCreateTableDefaultPermissionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataLakeSettingsCreateTableDefaultPermissionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.createTableDefaultPermissions = mapped
    }

    /**
     * @param argument Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
     */
    @JvmName("uofqyyrjtdoixhqv")
    public suspend fun createTableDefaultPermissions(vararg argument: suspend DataLakeSettingsCreateTableDefaultPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataLakeSettingsCreateTableDefaultPermissionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.createTableDefaultPermissions = mapped
    }

    /**
     * @param argument Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
     */
    @JvmName("ofvtaanyftveajcr")
    public suspend fun createTableDefaultPermissions(argument: suspend DataLakeSettingsCreateTableDefaultPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DataLakeSettingsCreateTableDefaultPermissionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.createTableDefaultPermissions = mapped
    }

    /**
     * @param values Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
     */
    @JvmName("deccwutjqklfigxg")
    public suspend fun createTableDefaultPermissions(vararg values: DataLakeSettingsCreateTableDefaultPermissionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createTableDefaultPermissions = mapped
    }

    /**
     * @param value A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.
     */
    @JvmName("ammumcmwlqhgorqh")
    public suspend fun externalDataFilteringAllowLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalDataFilteringAllowLists = mapped
    }

    /**
     * @param values A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.
     */
    @JvmName("mcrqsrwrfhenpvcw")
    public suspend fun externalDataFilteringAllowLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalDataFilteringAllowLists = mapped
    }

    /**
     * @param value Set of ARNs of AWS Lake Formation principals (IAM users or roles) with only view access to the resources.
     */
    @JvmName("aqkivtjdbwlchrqe")
    public suspend fun readOnlyAdmins(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnlyAdmins = mapped
    }

    /**
     * @param values Set of ARNs of AWS Lake Formation principals (IAM users or roles) with only view access to the resources.
     */
    @JvmName("landpopcbqpvqaun")
    public suspend fun readOnlyAdmins(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.readOnlyAdmins = mapped
    }

    /**
     * @param value List of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs).
     */
    @JvmName("vgowgqwfecbwclnb")
    public suspend fun trustedResourceOwners(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedResourceOwners = mapped
    }

    /**
     * @param values List of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs).
     */
    @JvmName("ksmywivhlyxqwgkf")
    public suspend fun trustedResourceOwners(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trustedResourceOwners = mapped
    }

    internal fun build(): DataLakeSettingsArgs = DataLakeSettingsArgs(
        admins = admins,
        allowExternalDataFiltering = allowExternalDataFiltering,
        allowFullTableExternalDataAccess = allowFullTableExternalDataAccess,
        authorizedSessionTagValueLists = authorizedSessionTagValueLists,
        catalogId = catalogId,
        createDatabaseDefaultPermissions = createDatabaseDefaultPermissions,
        createTableDefaultPermissions = createTableDefaultPermissions,
        externalDataFilteringAllowLists = externalDataFilteringAllowLists,
        readOnlyAdmins = readOnlyAdmins,
        trustedResourceOwners = trustedResourceOwners,
    )
}
