@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin

import com.pulumi.aws.lakeformation.LakeformationFunctions.getDataLakeSettingsPlain
import com.pulumi.aws.lakeformation.LakeformationFunctions.getPermissionsPlain
import com.pulumi.aws.lakeformation.LakeformationFunctions.getResourcePlain
import com.pulumi.aws.lakeformation.kotlin.inputs.GetDataLakeSettingsPlainArgs
import com.pulumi.aws.lakeformation.kotlin.inputs.GetDataLakeSettingsPlainArgsBuilder
import com.pulumi.aws.lakeformation.kotlin.inputs.GetPermissionsDataCellsFilter
import com.pulumi.aws.lakeformation.kotlin.inputs.GetPermissionsDataLocation
import com.pulumi.aws.lakeformation.kotlin.inputs.GetPermissionsDatabase
import com.pulumi.aws.lakeformation.kotlin.inputs.GetPermissionsLfTag
import com.pulumi.aws.lakeformation.kotlin.inputs.GetPermissionsLfTagPolicy
import com.pulumi.aws.lakeformation.kotlin.inputs.GetPermissionsPlainArgs
import com.pulumi.aws.lakeformation.kotlin.inputs.GetPermissionsPlainArgsBuilder
import com.pulumi.aws.lakeformation.kotlin.inputs.GetPermissionsTable
import com.pulumi.aws.lakeformation.kotlin.inputs.GetPermissionsTableWithColumns
import com.pulumi.aws.lakeformation.kotlin.inputs.GetResourcePlainArgs
import com.pulumi.aws.lakeformation.kotlin.inputs.GetResourcePlainArgsBuilder
import com.pulumi.aws.lakeformation.kotlin.outputs.GetDataLakeSettingsResult
import com.pulumi.aws.lakeformation.kotlin.outputs.GetPermissionsResult
import com.pulumi.aws.lakeformation.kotlin.outputs.GetResourceResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.lakeformation.kotlin.outputs.GetDataLakeSettingsResult.Companion.toKotlin as getDataLakeSettingsResultToKotlin
import com.pulumi.aws.lakeformation.kotlin.outputs.GetPermissionsResult.Companion.toKotlin as getPermissionsResultToKotlin
import com.pulumi.aws.lakeformation.kotlin.outputs.GetResourceResult.Companion.toKotlin as getResourceResultToKotlin

public object LakeformationFunctions {
    /**
     * Get Lake Formation principals designated as data lake administrators and lists of principal permission entries for default create database and default create table permissions.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.lakeformation.getDataLakeSettings({
     *     catalogId: "14916253649",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.lakeformation.get_data_lake_settings(catalog_id="14916253649")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.LakeFormation.GetDataLakeSettings.Invoke(new()
     *     {
     *         CatalogId = "14916253649",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lakeformation"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := lakeformation.LookupDataLakeSettings(ctx, &lakeformation.LookupDataLakeSettingsArgs{
     * 			CatalogId: pulumi.StringRef("14916253649"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lakeformation.LakeformationFunctions;
     * import com.pulumi.aws.lakeformation.inputs.GetDataLakeSettingsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = LakeformationFunctions.getDataLakeSettings(GetDataLakeSettingsArgs.builder()
     *             .catalogId("14916253649")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:lakeformation:getDataLakeSettings
     *       Arguments:
     *         catalogId: '14916253649'
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDataLakeSettings.
     * @return A collection of values returned by getDataLakeSettings.
     */
    public suspend fun getDataLakeSettings(argument: GetDataLakeSettingsPlainArgs): GetDataLakeSettingsResult =
        getDataLakeSettingsResultToKotlin(getDataLakeSettingsPlain(argument.toJava()).await())

    /**
     * @see [getDataLakeSettings].
     * @param catalogId Identifier for the Data Catalog. By default, the account ID.
     * @return A collection of values returned by getDataLakeSettings.
     */
    public suspend fun getDataLakeSettings(catalogId: String? = null): GetDataLakeSettingsResult {
        val argument = GetDataLakeSettingsPlainArgs(
            catalogId = catalogId,
        )
        return getDataLakeSettingsResultToKotlin(getDataLakeSettingsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataLakeSettings].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lakeformation&#46;kotlin&#46;inputs&#46;GetDataLakeSettingsPlainArgs].
     * @return A collection of values returned by getDataLakeSettings.
     */
    public suspend fun getDataLakeSettings(argument: suspend GetDataLakeSettingsPlainArgsBuilder.() -> Unit): GetDataLakeSettingsResult {
        val builder = GetDataLakeSettingsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataLakeSettingsResultToKotlin(getDataLakeSettingsPlain(builtArgument.toJava()).await())
    }

    /**
     * Get permissions for a principal to access metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3. Permissions are granted to a principal, in a Data Catalog, relative to a Lake Formation resource, which includes the Data Catalog, databases, tables, LF-tags, and LF-tag policies. For more information, see [Security and Access Control to Metadata and Data in Lake Formation](https://docs.aws.amazon.com/lake-formation/latest/dg/security-data-access.html).
     * > **NOTE:** This data source deals with explicitly granted permissions. Lake Formation grants implicit permissions to data lake administrators, database creators, and table creators. For more information, see [Implicit Lake Formation Permissions](https://docs.aws.amazon.com/lake-formation/latest/dg/implicit-permissions.html).
     * ## Example Usage
     * ### Permissions For A Lake Formation S3 Resource
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.lakeformation.getPermissions({
     *     principal: workflowRole.arn,
     *     dataLocation: {
     *         arn: testAwsLakeformationResource.arn,
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.lakeformation.get_permissions(principal=workflow_role["arn"],
     *     data_location={
     *         "arn": test_aws_lakeformation_resource["arn"],
     *     })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.LakeFormation.GetPermissions.Invoke(new()
     *     {
     *         Principal = workflowRole.Arn,
     *         DataLocation = new Aws.LakeFormation.Inputs.GetPermissionsDataLocationInputArgs
     *         {
     *             Arn = testAwsLakeformationResource.Arn,
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lakeformation"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := lakeformation.LookupPermissions(ctx, &lakeformation.LookupPermissionsArgs{
     * 			Principal: workflowRole.Arn,
     * 			DataLocation: lakeformation.GetPermissionsDataLocation{
     * 				Arn: testAwsLakeformationResource.Arn,
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lakeformation.LakeformationFunctions;
     * import com.pulumi.aws.lakeformation.inputs.GetPermissionsArgs;
     * import com.pulumi.aws.lakeformation.inputs.GetPermissionsDataLocationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = LakeformationFunctions.getPermissions(GetPermissionsArgs.builder()
     *             .principal(workflowRole.arn())
     *             .dataLocation(GetPermissionsDataLocationArgs.builder()
     *                 .arn(testAwsLakeformationResource.arn())
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:lakeformation:getPermissions
     *       Arguments:
     *         principal: ${workflowRole.arn}
     *         dataLocation:
     *           arn: ${testAwsLakeformationResource.arn}
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Permissions For A Glue Catalog Database
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.lakeformation.getPermissions({
     *     principal: workflowRole.arn,
     *     database: {
     *         name: testAwsGlueCatalogDatabase.name,
     *         catalogId: "110376042874",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.lakeformation.get_permissions(principal=workflow_role["arn"],
     *     database={
     *         "name": test_aws_glue_catalog_database["name"],
     *         "catalog_id": "110376042874",
     *     })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.LakeFormation.GetPermissions.Invoke(new()
     *     {
     *         Principal = workflowRole.Arn,
     *         Database = new Aws.LakeFormation.Inputs.GetPermissionsDatabaseInputArgs
     *         {
     *             Name = testAwsGlueCatalogDatabase.Name,
     *             CatalogId = "110376042874",
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lakeformation"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := lakeformation.LookupPermissions(ctx, &lakeformation.LookupPermissionsArgs{
     * 			Principal: workflowRole.Arn,
     * 			Database: lakeformation.GetPermissionsDatabase{
     * 				Name:      testAwsGlueCatalogDatabase.Name,
     * 				CatalogId: "110376042874",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lakeformation.LakeformationFunctions;
     * import com.pulumi.aws.lakeformation.inputs.GetPermissionsArgs;
     * import com.pulumi.aws.lakeformation.inputs.GetPermissionsDatabaseArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = LakeformationFunctions.getPermissions(GetPermissionsArgs.builder()
     *             .principal(workflowRole.arn())
     *             .database(GetPermissionsDatabaseArgs.builder()
     *                 .name(testAwsGlueCatalogDatabase.name())
     *                 .catalogId("110376042874")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:lakeformation:getPermissions
     *       Arguments:
     *         principal: ${workflowRole.arn}
     *         database:
     *           name: ${testAwsGlueCatalogDatabase.name}
     *           catalogId: '110376042874'
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Permissions For Tag-Based Access Control
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.lakeformation.getPermissions({
     *     principal: workflowRole.arn,
     *     lfTagPolicy: {
     *         resourceType: "DATABASE",
     *         expressions: [
     *             {
     *                 key: "Team",
     *                 values: ["Sales"],
     *             },
     *             {
     *                 key: "Environment",
     *                 values: [
     *                     "Dev",
     *                     "Production",
     *                 ],
     *             },
     *         ],
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.lakeformation.get_permissions(principal=workflow_role["arn"],
     *     lf_tag_policy={
     *         "resource_type": "DATABASE",
     *         "expressions": [
     *             {
     *                 "key": "Team",
     *                 "values": ["Sales"],
     *             },
     *             {
     *                 "key": "Environment",
     *                 "values": [
     *                     "Dev",
     *                     "Production",
     *                 ],
     *             },
     *         ],
     *     })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.LakeFormation.GetPermissions.Invoke(new()
     *     {
     *         Principal = workflowRole.Arn,
     *         LfTagPolicy = new Aws.LakeFormation.Inputs.GetPermissionsLfTagPolicyInputArgs
     *         {
     *             ResourceType = "DATABASE",
     *             Expressions = new[]
     *             {
     *                 new Aws.LakeFormation.Inputs.GetPermissionsLfTagPolicyExpressionInputArgs
     *                 {
     *                     Key = "Team",
     *                     Values = new[]
     *                     {
     *                         "Sales",
     *                     },
     *                 },
     *                 new Aws.LakeFormation.Inputs.GetPermissionsLfTagPolicyExpressionInputArgs
     *                 {
     *                     Key = "Environment",
     *                     Values = new[]
     *                     {
     *                         "Dev",
     *                         "Production",
     *                     },
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lakeformation"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := lakeformation.LookupPermissions(ctx, &lakeformation.LookupPermissionsArgs{
     * 			Principal: workflowRole.Arn,
     * 			LfTagPolicy: lakeformation.GetPermissionsLfTagPolicy{
     * 				ResourceType: "DATABASE",
     * 				Expressions: []lakeformation.GetPermissionsLfTagPolicyExpression{
     * 					{
     * 						Key: "Team",
     * 						Values: []string{
     * 							"Sales",
     * 						},
     * 					},
     * 					{
     * 						Key: "Environment",
     * 						Values: []string{
     * 							"Dev",
     * 							"Production",
     * 						},
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lakeformation.LakeformationFunctions;
     * import com.pulumi.aws.lakeformation.inputs.GetPermissionsArgs;
     * import com.pulumi.aws.lakeformation.inputs.GetPermissionsLfTagPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = LakeformationFunctions.getPermissions(GetPermissionsArgs.builder()
     *             .principal(workflowRole.arn())
     *             .lfTagPolicy(GetPermissionsLfTagPolicyArgs.builder()
     *                 .resourceType("DATABASE")
     *                 .expressions(
     *                     GetPermissionsLfTagPolicyExpressionArgs.builder()
     *                         .key("Team")
     *                         .values("Sales")
     *                         .build(),
     *                     GetPermissionsLfTagPolicyExpressionArgs.builder()
     *                         .key("Environment")
     *                         .values(
     *                             "Dev",
     *                             "Production")
     *                         .build())
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:lakeformation:getPermissions
     *       Arguments:
     *         principal: ${workflowRole.arn}
     *         lfTagPolicy:
     *           resourceType: DATABASE
     *           expressions:
     *             - key: Team
     *               values:
     *                 - Sales
     *             - key: Environment
     *               values:
     *                 - Dev
     *                 - Production
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPermissions.
     * @return A collection of values returned by getPermissions.
     */
    public suspend fun getPermissions(argument: GetPermissionsPlainArgs): GetPermissionsResult =
        getPermissionsResultToKotlin(getPermissionsPlain(argument.toJava()).await())

    /**
     * @see [getPermissions].
     * @param catalogId Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
     * @param catalogResource Whether the permissions are to be granted for the Data Catalog. Defaults to `false`.
     * @param dataCellsFilter Configuration block for a data cells filter resource. Detailed below.
     * @param dataLocation Configuration block for a data location resource. Detailed below.
     * @param database Configuration block for a database resource. Detailed below.
     * @param lfTag Configuration block for an LF-tag resource. Detailed below.
     * @param lfTagPolicy Configuration block for an LF-tag policy resource. Detailed below.
     * @param principal Principal to be granted the permissions on the resource. Supported principals are IAM users or IAM roles.
     * One of the following is required:
     * @param table Configuration block for a table resource. Detailed below.
     * @param tableWithColumns Configuration block for a table with columns resource. Detailed below.
     * The following arguments are optional:
     * @return A collection of values returned by getPermissions.
     */
    public suspend fun getPermissions(
        catalogId: String? = null,
        catalogResource: Boolean? = null,
        dataCellsFilter: GetPermissionsDataCellsFilter? = null,
        dataLocation: GetPermissionsDataLocation? = null,
        database: GetPermissionsDatabase? = null,
        lfTag: GetPermissionsLfTag? = null,
        lfTagPolicy: GetPermissionsLfTagPolicy? = null,
        principal: String,
        table: GetPermissionsTable? = null,
        tableWithColumns: GetPermissionsTableWithColumns? = null,
    ): GetPermissionsResult {
        val argument = GetPermissionsPlainArgs(
            catalogId = catalogId,
            catalogResource = catalogResource,
            dataCellsFilter = dataCellsFilter,
            dataLocation = dataLocation,
            database = database,
            lfTag = lfTag,
            lfTagPolicy = lfTagPolicy,
            principal = principal,
            table = table,
            tableWithColumns = tableWithColumns,
        )
        return getPermissionsResultToKotlin(getPermissionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getPermissions].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lakeformation&#46;kotlin&#46;inputs&#46;GetPermissionsPlainArgs].
     * @return A collection of values returned by getPermissions.
     */
    public suspend fun getPermissions(argument: suspend GetPermissionsPlainArgsBuilder.() -> Unit): GetPermissionsResult {
        val builder = GetPermissionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPermissionsResultToKotlin(getPermissionsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a Lake Formation resource.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.lakeformation.getResource({
     *     arn: "arn:aws:s3:::tf-acc-test-9151654063908211878",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.lakeformation.get_resource(arn="arn:aws:s3:::tf-acc-test-9151654063908211878")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.LakeFormation.GetResource.Invoke(new()
     *     {
     *         Arn = "arn:aws:s3:::tf-acc-test-9151654063908211878",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lakeformation"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := lakeformation.LookupResource(ctx, &lakeformation.LookupResourceArgs{
     * 			Arn: "arn:aws:s3:::tf-acc-test-9151654063908211878",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lakeformation.LakeformationFunctions;
     * import com.pulumi.aws.lakeformation.inputs.GetResourceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = LakeformationFunctions.getResource(GetResourceArgs.builder()
     *             .arn("arn:aws:s3:::tf-acc-test-9151654063908211878")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:lakeformation:getResource
     *       Arguments:
     *         arn: arn:aws:s3:::tf-acc-test-9151654063908211878
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getResource.
     * @return A collection of values returned by getResource.
     */
    public suspend fun getResource(argument: GetResourcePlainArgs): GetResourceResult =
        getResourceResultToKotlin(getResourcePlain(argument.toJava()).await())

    /**
     * @see [getResource].
     * @param arn ARN of the resource, an S3 path.
     * @return A collection of values returned by getResource.
     */
    public suspend fun getResource(arn: String): GetResourceResult {
        val argument = GetResourcePlainArgs(
            arn = arn,
        )
        return getResourceResultToKotlin(getResourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getResource].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lakeformation&#46;kotlin&#46;inputs&#46;GetResourcePlainArgs].
     * @return A collection of values returned by getResource.
     */
    public suspend fun getResource(argument: suspend GetResourcePlainArgsBuilder.() -> Unit): GetResourceResult {
        val builder = GetResourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResourceResultToKotlin(getResourcePlain(builtArgument.toJava()).await())
    }
}
