@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin

import com.pulumi.aws.lakeformation.LfTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Creates an LF-Tag with the specified name and values. Each key must have at least one value. The maximum number of values permitted is 1000.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lakeformation.LfTag("example", {
 *     key: "module",
 *     values: [
 *         "Orders",
 *         "Sales",
 *         "Customers",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lakeformation.LfTag("example",
 *     key="module",
 *     values=[
 *         "Orders",
 *         "Sales",
 *         "Customers",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.LakeFormation.LfTag("example", new()
 *     {
 *         Key = "module",
 *         Values = new[]
 *         {
 *             "Orders",
 *             "Sales",
 *             "Customers",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lakeformation"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lakeformation.NewLfTag(ctx, "example", &lakeformation.LfTagArgs{
 * 			Key: pulumi.String("module"),
 * 			Values: pulumi.StringArray{
 * 				pulumi.String("Orders"),
 * 				pulumi.String("Sales"),
 * 				pulumi.String("Customers"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.LfTag;
 * import com.pulumi.aws.lakeformation.LfTagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LfTag("example", LfTagArgs.builder()
 *             .key("module")
 *             .values(
 *                 "Orders",
 *                 "Sales",
 *                 "Customers")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lakeformation:LfTag
 *     properties:
 *       key: module
 *       values:
 *         - Orders
 *         - Sales
 *         - Customers
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Lake Formation LF-Tags using the `catalog_id:key`. If you have not set a Catalog ID specify the AWS Account ID that the database is in. For example:
 * ```sh
 * $ pulumi import aws:lakeformation/lfTag:LfTag example 123456789012:some_key
 * ```
 * @property catalogId ID of the Data Catalog to create the tag in. If omitted, this defaults to the AWS Account ID.
 * @property key Key-name for the tag.
 * @property values List of possible values an attribute can take.
 */
public data class LfTagArgs(
    public val catalogId: Output<String>? = null,
    public val key: Output<String>? = null,
    public val values: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.LfTagArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.LfTagArgs =
        com.pulumi.aws.lakeformation.LfTagArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 }))
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [LfTagArgs].
 */
@PulumiTagMarker
public class LfTagArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var key: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value ID of the Data Catalog to create the tag in. If omitted, this defaults to the AWS Account ID.
     */
    @JvmName("opijuduwrvdwaxoo")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value Key-name for the tag.
     */
    @JvmName("vracakutanlkduro")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value List of possible values an attribute can take.
     */
    @JvmName("kyombbfciepwivjq")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("wsurvbhornocpfyh")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values List of possible values an attribute can take.
     */
    @JvmName("diwgqesudejdryoc")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value ID of the Data Catalog to create the tag in. If omitted, this defaults to the AWS Account ID.
     */
    @JvmName("fhflyhuhdxmjrnnr")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value Key-name for the tag.
     */
    @JvmName("iedfgaertntvxxma")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value List of possible values an attribute can take.
     */
    @JvmName("xlrvwqbssfkujbly")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values List of possible values an attribute can take.
     */
    @JvmName("uyroioysdyefcirx")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): LfTagArgs = LfTagArgs(
        catalogId = catalogId,
        key = key,
        values = values,
    )
}
