@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin

import com.pulumi.aws.lakeformation.kotlin.outputs.PermissionsDataCellsFilter
import com.pulumi.aws.lakeformation.kotlin.outputs.PermissionsDataLocation
import com.pulumi.aws.lakeformation.kotlin.outputs.PermissionsDatabase
import com.pulumi.aws.lakeformation.kotlin.outputs.PermissionsLfTag
import com.pulumi.aws.lakeformation.kotlin.outputs.PermissionsLfTagPolicy
import com.pulumi.aws.lakeformation.kotlin.outputs.PermissionsTable
import com.pulumi.aws.lakeformation.kotlin.outputs.PermissionsTableWithColumns
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.lakeformation.kotlin.outputs.PermissionsDataCellsFilter.Companion.toKotlin as permissionsDataCellsFilterToKotlin
import com.pulumi.aws.lakeformation.kotlin.outputs.PermissionsDataLocation.Companion.toKotlin as permissionsDataLocationToKotlin
import com.pulumi.aws.lakeformation.kotlin.outputs.PermissionsDatabase.Companion.toKotlin as permissionsDatabaseToKotlin
import com.pulumi.aws.lakeformation.kotlin.outputs.PermissionsLfTag.Companion.toKotlin as permissionsLfTagToKotlin
import com.pulumi.aws.lakeformation.kotlin.outputs.PermissionsLfTagPolicy.Companion.toKotlin as permissionsLfTagPolicyToKotlin
import com.pulumi.aws.lakeformation.kotlin.outputs.PermissionsTable.Companion.toKotlin as permissionsTableToKotlin
import com.pulumi.aws.lakeformation.kotlin.outputs.PermissionsTableWithColumns.Companion.toKotlin as permissionsTableWithColumnsToKotlin

/**
 * Builder for [Permissions].
 */
@PulumiTagMarker
public class PermissionsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PermissionsArgs = PermissionsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PermissionsArgsBuilder.() -> Unit) {
        val builder = PermissionsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Permissions {
        val builtJavaResource = com.pulumi.aws.lakeformation.Permissions(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Permissions(builtJavaResource)
    }
}

/**
 * Grants permissions to the principal to access metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3. Permissions are granted to a principal, in a Data Catalog, relative to a Lake Formation resource, which includes the Data Catalog, databases, tables, LF-tags, and LF-tag policies. For more information, see [Security and Access Control to Metadata and Data in Lake Formation](https://docs.aws.amazon.com/lake-formation/latest/dg/security-data-access.html).
 * !> **WARNING:** Lake Formation permissions are not in effect by default within AWS. Using this resource will not secure your data and will result in errors if you do not change the security settings for existing resources and the default security settings for new resources. See Default Behavior and `IAMAllowedPrincipals` for additional details.
 * > **NOTE:** In general, the `principal` should _NOT_ be a Lake Formation administrator or the entity (e.g., IAM role) that is running the deployment. Administrators have implicit permissions. These should be managed by granting or not granting administrator rights using `aws.lakeformation.DataLakeSettings`, _not_ with this resource.
 * ## Default Behavior and `IAMAllowedPrincipals`
 * **_Lake Formation permissions are not in effect by default within AWS._** `IAMAllowedPrincipals` (i.e., `IAM_ALLOWED_PRINCIPALS`) conflicts with individual Lake Formation permissions (i.e., non-`IAMAllowedPrincipals` permissions), will cause unexpected behavior, and may result in errors.
 * When using Lake Formation, choose ONE of the following options as they are mutually exclusive:
 * 1. Use this resource (`aws.lakeformation.Permissions`), change the default security settings using `aws.lakeformation.DataLakeSettings`, and remove existing `IAMAllowedPrincipals` permissions
 * 2. Use `IAMAllowedPrincipals` without `aws.lakeformation.Permissions`
 * This example shows removing the `IAMAllowedPrincipals` default security settings and making the caller a Lake Formation admin. Since `create_database_default_permissions` and `create_table_default_permissions` are not set in the `aws.lakeformation.DataLakeSettings` resource, they are cleared.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getCallerIdentity({});
 * const currentGetSessionContext = current.then(current => aws.iam.getSessionContext({
 *     arn: current.arn,
 * }));
 * const test = new aws.lakeformation.DataLakeSettings("test", {admins: [currentGetSessionContext&#46;then(currentGetSessionContext => currentGetSessionContext&#46;issuerArn)]});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_caller_identity()
 * current_get_session_context = aws.iam.get_session_context(arn=current.arn)
 * test = aws.lakeformation.DataLakeSettings("test", admins=[current_get_session_context&#46;issuer_arn])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var currentGetSessionContext = Aws.Iam.GetSessionContext.Invoke(new()
 *     {
 *         Arn = current.Apply(getCallerIdentityResult => getCallerIdentityResult.Arn),
 *     });
 *     var test = new Aws.LakeFormation.DataLakeSettings("test", new()
 *     {
 *         Admins = new[]
 *         {
 *             currentGetSessionContext.Apply(getSessionContextResult => getSessionContextResult.IssuerArn),
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lakeformation"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		currentGetSessionContext, err := iam.GetSessionContext(ctx, &iam.GetSessionContextArgs{
 * 			Arn: current.Arn,
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lakeformation.NewDataLakeSettings(ctx, "test", &lakeformation.DataLakeSettingsArgs{
 * 			Admins: pulumi.StringArray{
 * 				pulumi.String(currentGetSessionContext.IssuerArn),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetSessionContextArgs;
 * import com.pulumi.aws.lakeformation.DataLakeSettings;
 * import com.pulumi.aws.lakeformation.DataLakeSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         final var currentGetSessionContext = IamFunctions.getSessionContext(GetSessionContextArgs.builder()
 *             .arn(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.arn()))
 *             .build());
 *         var test = new DataLakeSettings("test", DataLakeSettingsArgs.builder()
 *             .admins(currentGetSessionContext.applyValue(getSessionContextResult -> getSessionContextResult.issuerArn()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lakeformation:DataLakeSettings
 *     properties:
 *       admins:
 *         - ${currentGetSessionContext.issuerArn}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 *   currentGetSessionContext:
 *     fn::invoke:
 *       Function: aws:iam:getSessionContext
 *       Arguments:
 *         arn: ${current.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * To remove existing `IAMAllowedPrincipals` permissions, use the [AWS Lake Formation Console](https://console&#46;aws&#46;amazon&#46;com/lakeformation/) or [AWS CLI](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lakeformation/batch-revoke-permissions.html).
 * `IAMAllowedPrincipals` is a hook to maintain backwards compatibility with AWS Glue. `IAMAllowedPrincipals` is a pseudo-entity group that acts like a Lake Formation principal. The group includes any IAM users and roles that are allowed access to your Data Catalog resources by your IAM policies.
 * This is Lake Formation's default behavior:
 * * Lake Formation grants `Super` permission to `IAMAllowedPrincipals` on all existing AWS Glue Data Catalog resources.
 * * Lake Formation enables "Use only IAM access control" for new Data Catalog resources.
 * For more details, see [Changing the Default Security Settings for Your Data Lake](https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html).
 * ### Problem Using `IAMAllowedPrincipals`
 * AWS does not support combining `IAMAllowedPrincipals` permissions and non-`IAMAllowedPrincipals` permissions. Doing so results in unexpected permissions and behaviors. For example, this configuration grants a user `SELECT` on a column in a table.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.CatalogDatabase("example", {name: "sadabate"});
 * const exampleCatalogTable = new aws.glue.CatalogTable("example", {
 *     name: "abelt",
 *     databaseName: test.name,
 *     storageDescriptor: {
 *         columns: [{
 *             name: "event",
 *             type: "string",
 *         }],
 *     },
 * });
 * const examplePermissions = new aws.lakeformation.Permissions("example", {
 *     permissions: ["SELECT"],
 *     principal: "arn:aws:iam:us-east-1:123456789012:user/SanHolo",
 *     tableWithColumns: {
 *         databaseName: exampleCatalogTable.databaseName,
 *         name: exampleCatalogTable.name,
 *         columnNames: ["event"],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.CatalogDatabase("example", name="sadabate")
 * example_catalog_table = aws.glue.CatalogTable("example",
 *     name="abelt",
 *     database_name=test["name"],
 *     storage_descriptor={
 *         "columns": [{
 *             "name": "event",
 *             "type": "string",
 *         }],
 *     })
 * example_permissions = aws.lakeformation.Permissions("example",
 *     permissions=["SELECT"],
 *     principal="arn:aws:iam:us-east-1:123456789012:user/SanHolo",
 *     table_with_columns={
 *         "database_name": example_catalog_table.database_name,
 *         "name": example_catalog_table.name,
 *         "column_names": ["event"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.CatalogDatabase("example", new()
 *     {
 *         Name = "sadabate",
 *     });
 *     var exampleCatalogTable = new Aws.Glue.CatalogTable("example", new()
 *     {
 *         Name = "abelt",
 *         DatabaseName = test.Name,
 *         StorageDescriptor = new Aws.Glue.Inputs.CatalogTableStorageDescriptorArgs
 *         {
 *             Columns = new[]
 *             {
 *                 new Aws.Glue.Inputs.CatalogTableStorageDescriptorColumnArgs
 *                 {
 *                     Name = "event",
 *                     Type = "string",
 *                 },
 *             },
 *         },
 *     });
 *     var examplePermissions = new Aws.LakeFormation.Permissions("example", new()
 *     {
 *         PermissionDetails = new[]
 *         {
 *             "SELECT",
 *         },
 *         Principal = "arn:aws:iam:us-east-1:123456789012:user/SanHolo",
 *         TableWithColumns = new Aws.LakeFormation.Inputs.PermissionsTableWithColumnsArgs
 *         {
 *             DatabaseName = exampleCatalogTable.DatabaseName,
 *             Name = exampleCatalogTable.Name,
 *             ColumnNames = new[]
 *             {
 *                 "event",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lakeformation"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewCatalogDatabase(ctx, "example", &glue.CatalogDatabaseArgs{
 * 			Name: pulumi.String("sadabate"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleCatalogTable, err := glue.NewCatalogTable(ctx, "example", &glue.CatalogTableArgs{
 * 			Name:         pulumi.String("abelt"),
 * 			DatabaseName: pulumi.Any(test.Name),
 * 			StorageDescriptor: &glue.CatalogTableStorageDescriptorArgs{
 * 				Columns: glue.CatalogTableStorageDescriptorColumnArray{
 * 					&glue.CatalogTableStorageDescriptorColumnArgs{
 * 						Name: pulumi.String("event"),
 * 						Type: pulumi.String("string"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lakeformation.NewPermissions(ctx, "example", &lakeformation.PermissionsArgs{
 * 			Permissions: pulumi.StringArray{
 * 				pulumi.String("SELECT"),
 * 			},
 * 			Principal: pulumi.String("arn:aws:iam:us-east-1:123456789012:user/SanHolo"),
 * 			TableWithColumns: &lakeformation.PermissionsTableWithColumnsArgs{
 * 				DatabaseName: exampleCatalogTable.DatabaseName,
 * 				Name:         exampleCatalogTable.Name,
 * 				ColumnNames: pulumi.StringArray{
 * 					pulumi.String("event"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.CatalogDatabase;
 * import com.pulumi.aws.glue.CatalogDatabaseArgs;
 * import com.pulumi.aws.glue.CatalogTable;
 * import com.pulumi.aws.glue.CatalogTableArgs;
 * import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorArgs;
 * import com.pulumi.aws.lakeformation.Permissions;
 * import com.pulumi.aws.lakeformation.PermissionsArgs;
 * import com.pulumi.aws.lakeformation.inputs.PermissionsTableWithColumnsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CatalogDatabase("example", CatalogDatabaseArgs.builder()
 *             .name("sadabate")
 *             .build());
 *         var exampleCatalogTable = new CatalogTable("exampleCatalogTable", CatalogTableArgs.builder()
 *             .name("abelt")
 *             .databaseName(test.name())
 *             .storageDescriptor(CatalogTableStorageDescriptorArgs.builder()
 *                 .columns(CatalogTableStorageDescriptorColumnArgs.builder()
 *                     .name("event")
 *                     .type("string")
 *                     .build())
 *                 .build())
 *             .build());
 *         var examplePermissions = new Permissions("examplePermissions", PermissionsArgs.builder()
 *             .permissions("SELECT")
 *             .principal("arn:aws:iam:us-east-1:123456789012:user/SanHolo")
 *             .tableWithColumns(PermissionsTableWithColumnsArgs.builder()
 *                 .databaseName(exampleCatalogTable.databaseName())
 *                 .name(exampleCatalogTable.name())
 *                 .columnNames("event")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:CatalogDatabase
 *     properties:
 *       name: sadabate
 *   exampleCatalogTable:
 *     type: aws:glue:CatalogTable
 *     name: example
 *     properties:
 *       name: abelt
 *       databaseName: ${test.name}
 *       storageDescriptor:
 *         columns:
 *           - name: event
 *             type: string
 *   examplePermissions:
 *     type: aws:lakeformation:Permissions
 *     name: example
 *     properties:
 *       permissions:
 *         - SELECT
 *       principal: arn:aws:iam:us-east-1:123456789012:user/SanHolo
 *       tableWithColumns:
 *         databaseName: ${exampleCatalogTable.databaseName}
 *         name: ${exampleCatalogTable.name}
 *         columnNames:
 *           - event
 * ```
 * <!--End PulumiCodeChooser -->
 * The resulting permissions depend on whether the table had `IAMAllowedPrincipals` (IAP) permissions or not.
 * | Result With IAP | Result Without IAP |
 * | ---- | ---- |
 * | `SELECT` column wildcard (i.e., all columns) | `SELECT` on `"event"` (as expected) |
 * ## Using Lake Formation Permissions
 * Lake Formation grants implicit permissions to data lake administrators, database creators, and table creators. These implicit permissions cannot be revoked _per se_. If this resource reads implicit permissions, it will attempt to revoke them, which causes an error when the resource is destroyed.
 * There are two ways to avoid these errors. First, and the way we recommend, is to avoid using this resource with principals that have implicit permissions. A second, error-prone option, is to grant explicit permissions (and `permissions_with_grant_option`) to "overwrite" a principal's implicit permissions, which you can then revoke with this resource. For more information, see [Implicit Lake Formation Permissions](https://docs.aws.amazon.com/lake-formation/latest/dg/implicit-permissions.html).
 * If the `principal` is also a data lake administrator, AWS grants implicit permissions that can cause errors using this resource. For example, AWS implicitly grants a `principal`/administrator `permissions` and `permissions_with_grant_option` of `ALL`, `ALTER`, `DELETE`, `DESCRIBE`, `DROP`, `INSERT`, and `SELECT` on a table. If you use this resource to explicitly grant the `principal`/administrator `permissions` but _not_ `permissions_with_grant_option` of `ALL`, `ALTER`, `DELETE`, `DESCRIBE`, `DROP`, `INSERT`, and `SELECT` on the table, this resource will read the implicit `permissions_with_grant_option` and attempt to revoke them when the resource is destroyed. Doing so will cause an `InvalidInputException: No permissions revoked` error because you cannot revoke implicit permissions _per se_. To workaround this problem, explicitly grant the `principal`/administrator `permissions` _and_ `permissions_with_grant_option`, which can then be revoked. Similarly, granting a `principal`/administrator permissions on a table with columns and providing `column_names`, will result in a `InvalidInputException: Permissions modification is invalid` error because you are narrowing the implicit permissions. Instead, set `wildcard` to `true` and remove the `column_names`.
 * ## Example Usage
 * ### Grant Permissions For A Lake Formation S3 Resource
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lakeformation.Permissions("example", {
 *     principal: workflowRole.arn,
 *     permissions: ["DATA_LOCATION_ACCESS"],
 *     dataLocation: {
 *         arn: exampleAwsLakeformationResource.arn,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lakeformation.Permissions("example",
 *     principal=workflow_role["arn"],
 *     permissions=["DATA_LOCATION_ACCESS"],
 *     data_location={
 *         "arn": example_aws_lakeformation_resource["arn"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.LakeFormation.Permissions("example", new()
 *     {
 *         Principal = workflowRole.Arn,
 *         PermissionDetails = new[]
 *         {
 *             "DATA_LOCATION_ACCESS",
 *         },
 *         DataLocation = new Aws.LakeFormation.Inputs.PermissionsDataLocationArgs
 *         {
 *             Arn = exampleAwsLakeformationResource.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lakeformation"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lakeformation.NewPermissions(ctx, "example", &lakeformation.PermissionsArgs{
 * 			Principal: pulumi.Any(workflowRole.Arn),
 * 			Permissions: pulumi.StringArray{
 * 				pulumi.String("DATA_LOCATION_ACCESS"),
 * 			},
 * 			DataLocation: &lakeformation.PermissionsDataLocationArgs{
 * 				Arn: pulumi.Any(exampleAwsLakeformationResource.Arn),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.Permissions;
 * import com.pulumi.aws.lakeformation.PermissionsArgs;
 * import com.pulumi.aws.lakeformation.inputs.PermissionsDataLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Permissions("example", PermissionsArgs.builder()
 *             .principal(workflowRole.arn())
 *             .permissions("DATA_LOCATION_ACCESS")
 *             .dataLocation(PermissionsDataLocationArgs.builder()
 *                 .arn(exampleAwsLakeformationResource.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lakeformation:Permissions
 *     properties:
 *       principal: ${workflowRole.arn}
 *       permissions:
 *         - DATA_LOCATION_ACCESS
 *       dataLocation:
 *         arn: ${exampleAwsLakeformationResource.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Grant Permissions For A Glue Catalog Database
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lakeformation.Permissions("example", {
 *     principal: workflowRole.arn,
 *     permissions: [
 *         "CREATE_TABLE",
 *         "ALTER",
 *         "DROP",
 *     ],
 *     database: {
 *         name: exampleAwsGlueCatalogDatabase.name,
 *         catalogId: "110376042874",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lakeformation.Permissions("example",
 *     principal=workflow_role["arn"],
 *     permissions=[
 *         "CREATE_TABLE",
 *         "ALTER",
 *         "DROP",
 *     ],
 *     database={
 *         "name": example_aws_glue_catalog_database["name"],
 *         "catalog_id": "110376042874",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.LakeFormation.Permissions("example", new()
 *     {
 *         Principal = workflowRole.Arn,
 *         PermissionDetails = new[]
 *         {
 *             "CREATE_TABLE",
 *             "ALTER",
 *             "DROP",
 *         },
 *         Database = new Aws.LakeFormation.Inputs.PermissionsDatabaseArgs
 *         {
 *             Name = exampleAwsGlueCatalogDatabase.Name,
 *             CatalogId = "110376042874",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lakeformation"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lakeformation.NewPermissions(ctx, "example", &lakeformation.PermissionsArgs{
 * 			Principal: pulumi.Any(workflowRole.Arn),
 * 			Permissions: pulumi.StringArray{
 * 				pulumi.String("CREATE_TABLE"),
 * 				pulumi.String("ALTER"),
 * 				pulumi.String("DROP"),
 * 			},
 * 			Database: &lakeformation.PermissionsDatabaseArgs{
 * 				Name:      pulumi.Any(exampleAwsGlueCatalogDatabase.Name),
 * 				CatalogId: pulumi.String("110376042874"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.Permissions;
 * import com.pulumi.aws.lakeformation.PermissionsArgs;
 * import com.pulumi.aws.lakeformation.inputs.PermissionsDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Permissions("example", PermissionsArgs.builder()
 *             .principal(workflowRole.arn())
 *             .permissions(
 *                 "CREATE_TABLE",
 *                 "ALTER",
 *                 "DROP")
 *             .database(PermissionsDatabaseArgs.builder()
 *                 .name(exampleAwsGlueCatalogDatabase.name())
 *                 .catalogId("110376042874")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lakeformation:Permissions
 *     properties:
 *       principal: ${workflowRole.arn}
 *       permissions:
 *         - CREATE_TABLE
 *         - ALTER
 *         - DROP
 *       database:
 *         name: ${exampleAwsGlueCatalogDatabase.name}
 *         catalogId: '110376042874'
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Grant Permissions Using Tag-Based Access Control
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.lakeformation.Permissions("test", {
 *     principal: salesRole.arn,
 *     permissions: [
 *         "CREATE_TABLE",
 *         "ALTER",
 *         "DROP",
 *     ],
 *     lfTagPolicy: {
 *         resourceType: "DATABASE",
 *         expressions: [
 *             {
 *                 key: "Team",
 *                 values: ["Sales"],
 *             },
 *             {
 *                 key: "Environment",
 *                 values: [
 *                     "Dev",
 *                     "Production",
 *                 ],
 *             },
 *         ],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.lakeformation.Permissions("test",
 *     principal=sales_role["arn"],
 *     permissions=[
 *         "CREATE_TABLE",
 *         "ALTER",
 *         "DROP",
 *     ],
 *     lf_tag_policy={
 *         "resource_type": "DATABASE",
 *         "expressions": [
 *             {
 *                 "key": "Team",
 *                 "values": ["Sales"],
 *             },
 *             {
 *                 "key": "Environment",
 *                 "values": [
 *                     "Dev",
 *                     "Production",
 *                 ],
 *             },
 *         ],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.LakeFormation.Permissions("test", new()
 *     {
 *         Principal = salesRole.Arn,
 *         PermissionDetails = new[]
 *         {
 *             "CREATE_TABLE",
 *             "ALTER",
 *             "DROP",
 *         },
 *         LfTagPolicy = new Aws.LakeFormation.Inputs.PermissionsLfTagPolicyArgs
 *         {
 *             ResourceType = "DATABASE",
 *             Expressions = new[]
 *             {
 *                 new Aws.LakeFormation.Inputs.PermissionsLfTagPolicyExpressionArgs
 *                 {
 *                     Key = "Team",
 *                     Values = new[]
 *                     {
 *                         "Sales",
 *                     },
 *                 },
 *                 new Aws.LakeFormation.Inputs.PermissionsLfTagPolicyExpressionArgs
 *                 {
 *                     Key = "Environment",
 *                     Values = new[]
 *                     {
 *                         "Dev",
 *                         "Production",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lakeformation"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lakeformation.NewPermissions(ctx, "test", &lakeformation.PermissionsArgs{
 * 			Principal: pulumi.Any(salesRole.Arn),
 * 			Permissions: pulumi.StringArray{
 * 				pulumi.String("CREATE_TABLE"),
 * 				pulumi.String("ALTER"),
 * 				pulumi.String("DROP"),
 * 			},
 * 			LfTagPolicy: &lakeformation.PermissionsLfTagPolicyArgs{
 * 				ResourceType: pulumi.String("DATABASE"),
 * 				Expressions: lakeformation.PermissionsLfTagPolicyExpressionArray{
 * 					&lakeformation.PermissionsLfTagPolicyExpressionArgs{
 * 						Key: pulumi.String("Team"),
 * 						Values: pulumi.StringArray{
 * 							pulumi.String("Sales"),
 * 						},
 * 					},
 * 					&lakeformation.PermissionsLfTagPolicyExpressionArgs{
 * 						Key: pulumi.String("Environment"),
 * 						Values: pulumi.StringArray{
 * 							pulumi.String("Dev"),
 * 							pulumi.String("Production"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.Permissions;
 * import com.pulumi.aws.lakeformation.PermissionsArgs;
 * import com.pulumi.aws.lakeformation.inputs.PermissionsLfTagPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Permissions("test", PermissionsArgs.builder()
 *             .principal(salesRole.arn())
 *             .permissions(
 *                 "CREATE_TABLE",
 *                 "ALTER",
 *                 "DROP")
 *             .lfTagPolicy(PermissionsLfTagPolicyArgs.builder()
 *                 .resourceType("DATABASE")
 *                 .expressions(
 *                     PermissionsLfTagPolicyExpressionArgs.builder()
 *                         .key("Team")
 *                         .values("Sales")
 *                         .build(),
 *                     PermissionsLfTagPolicyExpressionArgs.builder()
 *                         .key("Environment")
 *                         .values(
 *                             "Dev",
 *                             "Production")
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lakeformation:Permissions
 *     properties:
 *       principal: ${salesRole.arn}
 *       permissions:
 *         - CREATE_TABLE
 *         - ALTER
 *         - DROP
 *       lfTagPolicy:
 *         resourceType: DATABASE
 *         expressions:
 *           - key: Team
 *             values:
 *               - Sales
 *           - key: Environment
 *             values:
 *               - Dev
 *               - Production
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class Permissions internal constructor(
    override val javaResource: com.pulumi.aws.lakeformation.Permissions,
) : KotlinCustomResource(javaResource, PermissionsMapper) {
    /**
     * Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
     */
    public val catalogId: Output<String>?
        get() = javaResource.catalogId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether the permissions are to be granted for the Data Catalog. Defaults to `false`.
     */
    public val catalogResource: Output<Boolean>?
        get() = javaResource.catalogResource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block for a data cells filter resource. Detailed below.
     */
    public val dataCellsFilter: Output<PermissionsDataCellsFilter>?
        get() = javaResource.dataCellsFilter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> permissionsDataCellsFilterToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Configuration block for a data location resource. Detailed below.
     */
    public val dataLocation: Output<PermissionsDataLocation>
        get() = javaResource.dataLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                permissionsDataLocationToKotlin(args0)
            })
        })

    /**
     * Configuration block for a database resource. Detailed below.
     */
    public val database: Output<PermissionsDatabase>
        get() = javaResource.database().applyValue({ args0 ->
            args0.let({ args0 ->
                permissionsDatabaseToKotlin(args0)
            })
        })

    /**
     * Configuration block for an LF-tag resource. Detailed below.
     */
    public val lfTag: Output<PermissionsLfTag>
        get() = javaResource.lfTag().applyValue({ args0 ->
            args0.let({ args0 ->
                permissionsLfTagToKotlin(args0)
            })
        })

    /**
     * Configuration block for an LF-tag policy resource. Detailed below.
     */
    public val lfTagPolicy: Output<PermissionsLfTagPolicy>
        get() = javaResource.lfTagPolicy().applyValue({ args0 ->
            args0.let({ args0 ->
                permissionsLfTagPolicyToKotlin(args0)
            })
        })

    /**
     * List of permissions granted to the principal. Valid values may include `ALL`, `ALTER`, `ASSOCIATE`, `CREATE_DATABASE`, `CREATE_TABLE`, `DATA_LOCATION_ACCESS`, `DELETE`, `DESCRIBE`, `DROP`, `INSERT`, and `SELECT`. For details on each permission, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
     */
    public val permissions: Output<List<String>>
        get() = javaResource.permissions().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Subset of `permissions` which the principal can pass.
     */
    public val permissionsWithGrantOptions: Output<List<String>>
        get() = javaResource.permissionsWithGrantOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * Principal to be granted the permissions on the resource. Supported principals include `IAM_ALLOWED_PRINCIPALS` (see Default Behavior and `IAMAllowedPrincipals` above), IAM roles, users, groups, SAML groups and users, QuickSight groups, OUs, and organizations as well as AWS account IDs for cross-account permissions. For more information, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
     * > **NOTE:** We highly recommend that the `principal` _NOT_ be a Lake Formation administrator (granted using `aws.lakeformation.DataLakeSettings`). The entity (e.g., IAM role) running the deployment will most likely need to be a Lake Formation administrator. As such, the entity will have implicit permissions and does not need permissions granted through this resource.
     * One of the following is required:
     */
    public val principal: Output<String>
        get() = javaResource.principal().applyValue({ args0 -> args0 })

    /**
     * Configuration block for a table resource. Detailed below.
     */
    public val table: Output<PermissionsTable>
        get() = javaResource.table().applyValue({ args0 ->
            args0.let({ args0 ->
                permissionsTableToKotlin(args0)
            })
        })

    /**
     * Configuration block for a table with columns resource. Detailed below.
     * The following arguments are optional:
     */
    public val tableWithColumns: Output<PermissionsTableWithColumns>
        get() = javaResource.tableWithColumns().applyValue({ args0 ->
            args0.let({ args0 ->
                permissionsTableWithColumnsToKotlin(args0)
            })
        })
}

public object PermissionsMapper : ResourceMapper<Permissions> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lakeformation.Permissions::class == javaResource::class

    override fun map(javaResource: Resource): Permissions = Permissions(
        javaResource as
            com.pulumi.aws.lakeformation.Permissions,
    )
}

/**
 * @see [Permissions].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Permissions].
 */
public suspend fun permissions(name: String, block: suspend PermissionsResourceBuilder.() -> Unit): Permissions {
    val builder = PermissionsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Permissions].
 * @param name The _unique_ name of the resulting resource.
 */
public fun permissions(name: String): Permissions {
    val builder = PermissionsResourceBuilder()
    builder.name(name)
    return builder.build()
}
