@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Resource].
 */
@PulumiTagMarker
public class ResourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceArgs = ResourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceArgsBuilder.() -> Unit) {
        val builder = ResourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Resource {
        val builtJavaResource = com.pulumi.aws.lakeformation.Resource(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Resource(builtJavaResource)
    }
}

/**
 * Registers a Lake Formation resource (e.g., S3 bucket) as managed by the Data Catalog. In other words, the S3 path is added to the data lake.
 * Choose a role that has read/write access to the chosen Amazon S3 path or use the service-linked role.
 * When you register the S3 path, the service-linked role and a new inline policy are created on your behalf.
 * Lake Formation adds the first path to the inline policy and attaches it to the service-linked role.
 * When you register subsequent paths, Lake Formation adds the path to the existing policy.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.s3.getBucket({
 *     bucket: "an-example-bucket",
 * });
 * const exampleResource = new aws.lakeformation.Resource("example", {arn: example.then(example => example.arn)});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.get_bucket(bucket="an-example-bucket")
 * example_resource = aws.lakeformation.Resource("example", arn=example.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.S3.GetBucket.Invoke(new()
 *     {
 *         Bucket = "an-example-bucket",
 *     });
 *     var exampleResource = new Aws.LakeFormation.Resource("example", new()
 *     {
 *         Arn = example.Apply(getBucketResult => getBucketResult.Arn),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lakeformation"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3.LookupBucket(ctx, &s3.LookupBucketArgs{
 * 			Bucket: "an-example-bucket",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lakeformation.NewResource(ctx, "example", &lakeformation.ResourceArgs{
 * 			Arn: pulumi.String(example.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.S3Functions;
 * import com.pulumi.aws.s3.inputs.GetBucketArgs;
 * import com.pulumi.aws.lakeformation.Resource;
 * import com.pulumi.aws.lakeformation.ResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = S3Functions.getBucket(GetBucketArgs.builder()
 *             .bucket("an-example-bucket")
 *             .build());
 *         var exampleResource = new Resource("exampleResource", ResourceArgs.builder()
 *             .arn(example.applyValue(getBucketResult -> getBucketResult.arn()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleResource:
 *     type: aws:lakeformation:Resource
 *     name: example
 *     properties:
 *       arn: ${example.arn}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:s3:getBucket
 *       Arguments:
 *         bucket: an-example-bucket
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class Resource internal constructor(
    override val javaResource: com.pulumi.aws.lakeformation.Resource,
) : KotlinCustomResource(javaResource, ResourceMapper) {
    /**
     * Amazon Resource Name (ARN) of the resource.
     * The following arguments are optional:
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Flag to enable AWS LakeFormation hybrid access permission mode.
     * > **NOTE:** AWS does not support registering an S3 location with an IAM role and subsequently updating the S3 location registration to a service-linked role.
     */
    public val hybridAccessEnabled: Output<Boolean>
        get() = javaResource.hybridAccessEnabled().applyValue({ args0 -> args0 })

    /**
     * Date and time the resource was last modified in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    public val lastModified: Output<String>
        get() = javaResource.lastModified().applyValue({ args0 -> args0 })

    /**
     * Role that has read/write access to the resource.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * Designates an AWS Identity and Access Management (IAM) service-linked role by registering this role with the Data Catalog.
     */
    public val useServiceLinkedRole: Output<Boolean>?
        get() = javaResource.useServiceLinkedRole().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val withFederation: Output<Boolean>
        get() = javaResource.withFederation().applyValue({ args0 -> args0 })
}

public object ResourceMapper : ResourceMapper<Resource> {
    override fun supportsMappingOfType(javaResource: com.pulumi.resources.Resource): Boolean =
        com.pulumi.aws.lakeformation.Resource::class == javaResource::class

    override fun map(javaResource: com.pulumi.resources.Resource): Resource = Resource(
        javaResource as
            com.pulumi.aws.lakeformation.Resource,
    )
}

/**
 * @see [Resource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Resource].
 */
public suspend fun resource(name: String, block: suspend ResourceResourceBuilder.() -> Unit): Resource {
    val builder = ResourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Resource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resource(name: String): Resource {
    val builder = ResourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
