@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin

import com.pulumi.aws.lakeformation.ResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Registers a Lake Formation resource (e.g., S3 bucket) as managed by the Data Catalog. In other words, the S3 path is added to the data lake.
 * Choose a role that has read/write access to the chosen Amazon S3 path or use the service-linked role.
 * When you register the S3 path, the service-linked role and a new inline policy are created on your behalf.
 * Lake Formation adds the first path to the inline policy and attaches it to the service-linked role.
 * When you register subsequent paths, Lake Formation adds the path to the existing policy.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.s3.getBucket({
 *     bucket: "an-example-bucket",
 * });
 * const exampleResource = new aws.lakeformation.Resource("example", {arn: example.then(example => example.arn)});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.get_bucket(bucket="an-example-bucket")
 * example_resource = aws.lakeformation.Resource("example", arn=example.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.S3.GetBucket.Invoke(new()
 *     {
 *         Bucket = "an-example-bucket",
 *     });
 *     var exampleResource = new Aws.LakeFormation.Resource("example", new()
 *     {
 *         Arn = example.Apply(getBucketResult => getBucketResult.Arn),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lakeformation"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3.LookupBucket(ctx, &s3.LookupBucketArgs{
 * 			Bucket: "an-example-bucket",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lakeformation.NewResource(ctx, "example", &lakeformation.ResourceArgs{
 * 			Arn: pulumi.String(example.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.S3Functions;
 * import com.pulumi.aws.s3.inputs.GetBucketArgs;
 * import com.pulumi.aws.lakeformation.Resource;
 * import com.pulumi.aws.lakeformation.ResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = S3Functions.getBucket(GetBucketArgs.builder()
 *             .bucket("an-example-bucket")
 *             .build());
 *         var exampleResource = new Resource("exampleResource", ResourceArgs.builder()
 *             .arn(example.applyValue(getBucketResult -> getBucketResult.arn()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleResource:
 *     type: aws:lakeformation:Resource
 *     name: example
 *     properties:
 *       arn: ${example.arn}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:s3:getBucket
 *       Arguments:
 *         bucket: an-example-bucket
 * ```
 * <!--End PulumiCodeChooser -->
 * @property arn Amazon Resource Name (ARN) of the resource.
 * The following arguments are optional:
 * @property hybridAccessEnabled Flag to enable AWS LakeFormation hybrid access permission mode.
 * > **NOTE:** AWS does not support registering an S3 location with an IAM role and subsequently updating the S3 location registration to a service-linked role.
 * @property roleArn Role that has read/write access to the resource.
 * @property useServiceLinkedRole Designates an AWS Identity and Access Management (IAM) service-linked role by registering this role with the Data Catalog.
 * @property withFederation
 */
public data class ResourceArgs(
    public val arn: Output<String>? = null,
    public val hybridAccessEnabled: Output<Boolean>? = null,
    public val roleArn: Output<String>? = null,
    public val useServiceLinkedRole: Output<Boolean>? = null,
    public val withFederation: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.ResourceArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.ResourceArgs =
        com.pulumi.aws.lakeformation.ResourceArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 }))
            .hybridAccessEnabled(hybridAccessEnabled?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .useServiceLinkedRole(useServiceLinkedRole?.applyValue({ args0 -> args0 }))
            .withFederation(withFederation?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceArgs].
 */
@PulumiTagMarker
public class ResourceArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var hybridAccessEnabled: Output<Boolean>? = null

    private var roleArn: Output<String>? = null

    private var useServiceLinkedRole: Output<Boolean>? = null

    private var withFederation: Output<Boolean>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the resource.
     * The following arguments are optional:
     */
    @JvmName("snuoyhhybyyawfpx")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value Flag to enable AWS LakeFormation hybrid access permission mode.
     * > **NOTE:** AWS does not support registering an S3 location with an IAM role and subsequently updating the S3 location registration to a service-linked role.
     */
    @JvmName("tiicdgvvmsvicuhh")
    public suspend fun hybridAccessEnabled(`value`: Output<Boolean>) {
        this.hybridAccessEnabled = value
    }

    /**
     * @param value Role that has read/write access to the resource.
     */
    @JvmName("nnyjkcclwcvjqttw")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Designates an AWS Identity and Access Management (IAM) service-linked role by registering this role with the Data Catalog.
     */
    @JvmName("trmjcuachvponbgy")
    public suspend fun useServiceLinkedRole(`value`: Output<Boolean>) {
        this.useServiceLinkedRole = value
    }

    /**
     * @param value
     */
    @JvmName("ujkdsawddgpjhilq")
    public suspend fun withFederation(`value`: Output<Boolean>) {
        this.withFederation = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the resource.
     * The following arguments are optional:
     */
    @JvmName("pqujleklqjdvaoro")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value Flag to enable AWS LakeFormation hybrid access permission mode.
     * > **NOTE:** AWS does not support registering an S3 location with an IAM role and subsequently updating the S3 location registration to a service-linked role.
     */
    @JvmName("wnelkshwbbauyoyc")
    public suspend fun hybridAccessEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hybridAccessEnabled = mapped
    }

    /**
     * @param value Role that has read/write access to the resource.
     */
    @JvmName("idbvbqjuuxvvxmkx")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Designates an AWS Identity and Access Management (IAM) service-linked role by registering this role with the Data Catalog.
     */
    @JvmName("aedxyswwjxpgjsrg")
    public suspend fun useServiceLinkedRole(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useServiceLinkedRole = mapped
    }

    /**
     * @param value
     */
    @JvmName("neroyjijghairkcs")
    public suspend fun withFederation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.withFederation = mapped
    }

    internal fun build(): ResourceArgs = ResourceArgs(
        arn = arn,
        hybridAccessEnabled = hybridAccessEnabled,
        roleArn = roleArn,
        useServiceLinkedRole = useServiceLinkedRole,
        withFederation = withFederation,
    )
}
