@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin

import com.pulumi.aws.lakeformation.kotlin.outputs.ResourceLfTagDatabase
import com.pulumi.aws.lakeformation.kotlin.outputs.ResourceLfTagLfTag
import com.pulumi.aws.lakeformation.kotlin.outputs.ResourceLfTagTable
import com.pulumi.aws.lakeformation.kotlin.outputs.ResourceLfTagTableWithColumns
import com.pulumi.aws.lakeformation.kotlin.outputs.ResourceLfTagTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.lakeformation.kotlin.outputs.ResourceLfTagDatabase.Companion.toKotlin as resourceLfTagDatabaseToKotlin
import com.pulumi.aws.lakeformation.kotlin.outputs.ResourceLfTagLfTag.Companion.toKotlin as resourceLfTagLfTagToKotlin
import com.pulumi.aws.lakeformation.kotlin.outputs.ResourceLfTagTable.Companion.toKotlin as resourceLfTagTableToKotlin
import com.pulumi.aws.lakeformation.kotlin.outputs.ResourceLfTagTableWithColumns.Companion.toKotlin as resourceLfTagTableWithColumnsToKotlin
import com.pulumi.aws.lakeformation.kotlin.outputs.ResourceLfTagTimeouts.Companion.toKotlin as resourceLfTagTimeoutsToKotlin

/**
 * Builder for [ResourceLfTag].
 */
@PulumiTagMarker
public class ResourceLfTagResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceLfTagArgs = ResourceLfTagArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceLfTagArgsBuilder.() -> Unit) {
        val builder = ResourceLfTagArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ResourceLfTag {
        val builtJavaResource = com.pulumi.aws.lakeformation.ResourceLfTag(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResourceLfTag(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Lake Formation Resource LF Tag.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lakeformation.ResourceLfTag("example", {
 *     database: {
 *         name: exampleAwsGlueCatalogDatabase.name,
 *     },
 *     lfTag: {
 *         key: exampleAwsLakeformationLfTag.key,
 *         value: "stowe",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lakeformation.ResourceLfTag("example",
 *     database={
 *         "name": example_aws_glue_catalog_database["name"],
 *     },
 *     lf_tag={
 *         "key": example_aws_lakeformation_lf_tag["key"],
 *         "value": "stowe",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.LakeFormation.ResourceLfTag("example", new()
 *     {
 *         Database = new Aws.LakeFormation.Inputs.ResourceLfTagDatabaseArgs
 *         {
 *             Name = exampleAwsGlueCatalogDatabase.Name,
 *         },
 *         LfTag = new Aws.LakeFormation.Inputs.ResourceLfTagLfTagArgs
 *         {
 *             Key = exampleAwsLakeformationLfTag.Key,
 *             Value = "stowe",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lakeformation"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lakeformation.NewResourceLfTag(ctx, "example", &lakeformation.ResourceLfTagArgs{
 * 			Database: &lakeformation.ResourceLfTagDatabaseArgs{
 * 				Name: pulumi.Any(exampleAwsGlueCatalogDatabase.Name),
 * 			},
 * 			LfTag: &lakeformation.ResourceLfTagLfTagArgs{
 * 				Key:   pulumi.Any(exampleAwsLakeformationLfTag.Key),
 * 				Value: pulumi.String("stowe"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.ResourceLfTag;
 * import com.pulumi.aws.lakeformation.ResourceLfTagArgs;
 * import com.pulumi.aws.lakeformation.inputs.ResourceLfTagDatabaseArgs;
 * import com.pulumi.aws.lakeformation.inputs.ResourceLfTagLfTagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourceLfTag("example", ResourceLfTagArgs.builder()
 *             .database(ResourceLfTagDatabaseArgs.builder()
 *                 .name(exampleAwsGlueCatalogDatabase.name())
 *                 .build())
 *             .lfTag(ResourceLfTagLfTagArgs.builder()
 *                 .key(exampleAwsLakeformationLfTag.key())
 *                 .value("stowe")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lakeformation:ResourceLfTag
 *     properties:
 *       database:
 *         name: ${exampleAwsGlueCatalogDatabase.name}
 *       lfTag:
 *         key: ${exampleAwsLakeformationLfTag.key}
 *         value: stowe
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You cannot import this resource.
 */
public class ResourceLfTag internal constructor(
    override val javaResource: com.pulumi.aws.lakeformation.ResourceLfTag,
) : KotlinCustomResource(javaResource, ResourceLfTagMapper) {
    /**
     * Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
     */
    public val catalogId: Output<String>?
        get() = javaResource.catalogId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Configuration block for a database resource. See Database for more details.
     */
    public val database: Output<ResourceLfTagDatabase>?
        get() = javaResource.database().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceLfTagDatabaseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Set of LF-tags to attach to the resource. See LF Tag for more details.
     * Exactly one of the following is required:
     */
    public val lfTag: Output<ResourceLfTagLfTag>?
        get() = javaResource.lfTag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceLfTagLfTagToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Configuration block for a table resource. See Table for more details.
     */
    public val table: Output<ResourceLfTagTable>?
        get() = javaResource.table().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceLfTagTableToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Configuration block for a table with columns resource. See Table With Columns for more details.
     * The following arguments are optional:
     */
    public val tableWithColumns: Output<ResourceLfTagTableWithColumns>?
        get() = javaResource.tableWithColumns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> resourceLfTagTableWithColumnsToKotlin(args0) })
            }).orElse(null)
        })

    public val timeouts: Output<ResourceLfTagTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceLfTagTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object ResourceLfTagMapper : ResourceMapper<ResourceLfTag> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lakeformation.ResourceLfTag::class == javaResource::class

    override fun map(javaResource: Resource): ResourceLfTag = ResourceLfTag(
        javaResource as
            com.pulumi.aws.lakeformation.ResourceLfTag,
    )
}

/**
 * @see [ResourceLfTag].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResourceLfTag].
 */
public suspend fun resourceLfTag(
    name: String,
    block: suspend ResourceLfTagResourceBuilder.() -> Unit,
): ResourceLfTag {
    val builder = ResourceLfTagResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResourceLfTag].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resourceLfTag(name: String): ResourceLfTag {
    val builder = ResourceLfTagResourceBuilder()
    builder.name(name)
    return builder.build()
}
