@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin

import com.pulumi.aws.lakeformation.ResourceLfTagArgs.builder
import com.pulumi.aws.lakeformation.kotlin.inputs.ResourceLfTagDatabaseArgs
import com.pulumi.aws.lakeformation.kotlin.inputs.ResourceLfTagDatabaseArgsBuilder
import com.pulumi.aws.lakeformation.kotlin.inputs.ResourceLfTagLfTagArgs
import com.pulumi.aws.lakeformation.kotlin.inputs.ResourceLfTagLfTagArgsBuilder
import com.pulumi.aws.lakeformation.kotlin.inputs.ResourceLfTagTableArgs
import com.pulumi.aws.lakeformation.kotlin.inputs.ResourceLfTagTableArgsBuilder
import com.pulumi.aws.lakeformation.kotlin.inputs.ResourceLfTagTableWithColumnsArgs
import com.pulumi.aws.lakeformation.kotlin.inputs.ResourceLfTagTableWithColumnsArgsBuilder
import com.pulumi.aws.lakeformation.kotlin.inputs.ResourceLfTagTimeoutsArgs
import com.pulumi.aws.lakeformation.kotlin.inputs.ResourceLfTagTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Lake Formation Resource LF Tag.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lakeformation.ResourceLfTag("example", {
 *     database: {
 *         name: exampleAwsGlueCatalogDatabase.name,
 *     },
 *     lfTag: {
 *         key: exampleAwsLakeformationLfTag.key,
 *         value: "stowe",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lakeformation.ResourceLfTag("example",
 *     database={
 *         "name": example_aws_glue_catalog_database["name"],
 *     },
 *     lf_tag={
 *         "key": example_aws_lakeformation_lf_tag["key"],
 *         "value": "stowe",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.LakeFormation.ResourceLfTag("example", new()
 *     {
 *         Database = new Aws.LakeFormation.Inputs.ResourceLfTagDatabaseArgs
 *         {
 *             Name = exampleAwsGlueCatalogDatabase.Name,
 *         },
 *         LfTag = new Aws.LakeFormation.Inputs.ResourceLfTagLfTagArgs
 *         {
 *             Key = exampleAwsLakeformationLfTag.Key,
 *             Value = "stowe",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lakeformation"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lakeformation.NewResourceLfTag(ctx, "example", &lakeformation.ResourceLfTagArgs{
 * 			Database: &lakeformation.ResourceLfTagDatabaseArgs{
 * 				Name: pulumi.Any(exampleAwsGlueCatalogDatabase.Name),
 * 			},
 * 			LfTag: &lakeformation.ResourceLfTagLfTagArgs{
 * 				Key:   pulumi.Any(exampleAwsLakeformationLfTag.Key),
 * 				Value: pulumi.String("stowe"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.ResourceLfTag;
 * import com.pulumi.aws.lakeformation.ResourceLfTagArgs;
 * import com.pulumi.aws.lakeformation.inputs.ResourceLfTagDatabaseArgs;
 * import com.pulumi.aws.lakeformation.inputs.ResourceLfTagLfTagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourceLfTag("example", ResourceLfTagArgs.builder()
 *             .database(ResourceLfTagDatabaseArgs.builder()
 *                 .name(exampleAwsGlueCatalogDatabase.name())
 *                 .build())
 *             .lfTag(ResourceLfTagLfTagArgs.builder()
 *                 .key(exampleAwsLakeformationLfTag.key())
 *                 .value("stowe")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lakeformation:ResourceLfTag
 *     properties:
 *       database:
 *         name: ${exampleAwsGlueCatalogDatabase.name}
 *       lfTag:
 *         key: ${exampleAwsLakeformationLfTag.key}
 *         value: stowe
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You cannot import this resource.
 * @property catalogId Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
 * @property database Configuration block for a database resource. See Database for more details.
 * @property lfTag Set of LF-tags to attach to the resource. See LF Tag for more details.
 * Exactly one of the following is required:
 * @property table Configuration block for a table resource. See Table for more details.
 * @property tableWithColumns Configuration block for a table with columns resource. See Table With Columns for more details.
 * The following arguments are optional:
 * @property timeouts
 */
public data class ResourceLfTagArgs(
    public val catalogId: Output<String>? = null,
    public val database: Output<ResourceLfTagDatabaseArgs>? = null,
    public val lfTag: Output<ResourceLfTagLfTagArgs>? = null,
    public val table: Output<ResourceLfTagTableArgs>? = null,
    public val tableWithColumns: Output<ResourceLfTagTableWithColumnsArgs>? = null,
    public val timeouts: Output<ResourceLfTagTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.ResourceLfTagArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.ResourceLfTagArgs =
        com.pulumi.aws.lakeformation.ResourceLfTagArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .database(database?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .lfTag(lfTag?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .table(table?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tableWithColumns(tableWithColumns?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ResourceLfTagArgs].
 */
@PulumiTagMarker
public class ResourceLfTagArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var database: Output<ResourceLfTagDatabaseArgs>? = null

    private var lfTag: Output<ResourceLfTagLfTagArgs>? = null

    private var table: Output<ResourceLfTagTableArgs>? = null

    private var tableWithColumns: Output<ResourceLfTagTableWithColumnsArgs>? = null

    private var timeouts: Output<ResourceLfTagTimeoutsArgs>? = null

    /**
     * @param value Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
     */
    @JvmName("mdvniloedbpamcln")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value Configuration block for a database resource. See Database for more details.
     */
    @JvmName("tsdcjxbrajvrshnd")
    public suspend fun database(`value`: Output<ResourceLfTagDatabaseArgs>) {
        this.database = value
    }

    /**
     * @param value Set of LF-tags to attach to the resource. See LF Tag for more details.
     * Exactly one of the following is required:
     */
    @JvmName("omjlhcuxnipweybc")
    public suspend fun lfTag(`value`: Output<ResourceLfTagLfTagArgs>) {
        this.lfTag = value
    }

    /**
     * @param value Configuration block for a table resource. See Table for more details.
     */
    @JvmName("vshfifxvyuylvoib")
    public suspend fun table(`value`: Output<ResourceLfTagTableArgs>) {
        this.table = value
    }

    /**
     * @param value Configuration block for a table with columns resource. See Table With Columns for more details.
     * The following arguments are optional:
     */
    @JvmName("fodwyojvjchahagx")
    public suspend fun tableWithColumns(`value`: Output<ResourceLfTagTableWithColumnsArgs>) {
        this.tableWithColumns = value
    }

    /**
     * @param value
     */
    @JvmName("sxndfpjhemaeksga")
    public suspend fun timeouts(`value`: Output<ResourceLfTagTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
     */
    @JvmName("pxsbxhvjrtypmjfq")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value Configuration block for a database resource. See Database for more details.
     */
    @JvmName("gxjjepdghfpuaedj")
    public suspend fun database(`value`: ResourceLfTagDatabaseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param argument Configuration block for a database resource. See Database for more details.
     */
    @JvmName("sspkccbwbymxvfyh")
    public suspend fun database(argument: suspend ResourceLfTagDatabaseArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceLfTagDatabaseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.database = mapped
    }

    /**
     * @param value Set of LF-tags to attach to the resource. See LF Tag for more details.
     * Exactly one of the following is required:
     */
    @JvmName("ikyvbjcoftruiulu")
    public suspend fun lfTag(`value`: ResourceLfTagLfTagArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lfTag = mapped
    }

    /**
     * @param argument Set of LF-tags to attach to the resource. See LF Tag for more details.
     * Exactly one of the following is required:
     */
    @JvmName("mngimcudoagfgsgn")
    public suspend fun lfTag(argument: suspend ResourceLfTagLfTagArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceLfTagLfTagArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.lfTag = mapped
    }

    /**
     * @param value Configuration block for a table resource. See Table for more details.
     */
    @JvmName("uymrjbcebkxfpqqa")
    public suspend fun table(`value`: ResourceLfTagTableArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.table = mapped
    }

    /**
     * @param argument Configuration block for a table resource. See Table for more details.
     */
    @JvmName("txdfvayqgcsuorlw")
    public suspend fun table(argument: suspend ResourceLfTagTableArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceLfTagTableArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.table = mapped
    }

    /**
     * @param value Configuration block for a table with columns resource. See Table With Columns for more details.
     * The following arguments are optional:
     */
    @JvmName("htmmsthttcwbpmgf")
    public suspend fun tableWithColumns(`value`: ResourceLfTagTableWithColumnsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableWithColumns = mapped
    }

    /**
     * @param argument Configuration block for a table with columns resource. See Table With Columns for more details.
     * The following arguments are optional:
     */
    @JvmName("ituykvhveyhgiutr")
    public suspend fun tableWithColumns(argument: suspend ResourceLfTagTableWithColumnsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceLfTagTableWithColumnsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tableWithColumns = mapped
    }

    /**
     * @param value
     */
    @JvmName("oelpvhcqphetomdm")
    public suspend fun timeouts(`value`: ResourceLfTagTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bucesptrwqiepqvy")
    public suspend fun timeouts(argument: suspend ResourceLfTagTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceLfTagTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): ResourceLfTagArgs = ResourceLfTagArgs(
        catalogId = catalogId,
        database = database,
        lfTag = lfTag,
        table = table,
        tableWithColumns = tableWithColumns,
        timeouts = timeouts,
    )
}
