@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin

import com.pulumi.aws.lakeformation.ResourceLfTagsArgs.builder
import com.pulumi.aws.lakeformation.kotlin.inputs.ResourceLfTagsDatabaseArgs
import com.pulumi.aws.lakeformation.kotlin.inputs.ResourceLfTagsDatabaseArgsBuilder
import com.pulumi.aws.lakeformation.kotlin.inputs.ResourceLfTagsLfTagArgs
import com.pulumi.aws.lakeformation.kotlin.inputs.ResourceLfTagsLfTagArgsBuilder
import com.pulumi.aws.lakeformation.kotlin.inputs.ResourceLfTagsTableArgs
import com.pulumi.aws.lakeformation.kotlin.inputs.ResourceLfTagsTableArgsBuilder
import com.pulumi.aws.lakeformation.kotlin.inputs.ResourceLfTagsTableWithColumnsArgs
import com.pulumi.aws.lakeformation.kotlin.inputs.ResourceLfTagsTableWithColumnsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Manages an attachment between one or more existing LF-tags and an existing Lake Formation resource.
 * ## Example Usage
 * ### Database Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lakeformation.LfTag("example", {
 *     key: "right",
 *     values: [
 *         "abbey",
 *         "village",
 *         "luffield",
 *         "woodcote",
 *         "copse",
 *         "chapel",
 *         "stowe",
 *         "club",
 *     ],
 * });
 * const exampleResourceLfTags = new aws.lakeformation.ResourceLfTags("example", {
 *     database: {
 *         name: exampleAwsGlueCatalogDatabase.name,
 *     },
 *     lfTags: [{
 *         key: example.key,
 *         value: "stowe",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lakeformation.LfTag("example",
 *     key="right",
 *     values=[
 *         "abbey",
 *         "village",
 *         "luffield",
 *         "woodcote",
 *         "copse",
 *         "chapel",
 *         "stowe",
 *         "club",
 *     ])
 * example_resource_lf_tags = aws.lakeformation.ResourceLfTags("example",
 *     database={
 *         "name": example_aws_glue_catalog_database["name"],
 *     },
 *     lf_tags=[{
 *         "key": example.key,
 *         "value": "stowe",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.LakeFormation.LfTag("example", new()
 *     {
 *         Key = "right",
 *         Values = new[]
 *         {
 *             "abbey",
 *             "village",
 *             "luffield",
 *             "woodcote",
 *             "copse",
 *             "chapel",
 *             "stowe",
 *             "club",
 *         },
 *     });
 *     var exampleResourceLfTags = new Aws.LakeFormation.ResourceLfTags("example", new()
 *     {
 *         Database = new Aws.LakeFormation.Inputs.ResourceLfTagsDatabaseArgs
 *         {
 *             Name = exampleAwsGlueCatalogDatabase.Name,
 *         },
 *         LfTags = new[]
 *         {
 *             new Aws.LakeFormation.Inputs.ResourceLfTagsLfTagArgs
 *             {
 *                 Key = example.Key,
 *                 Value = "stowe",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lakeformation"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := lakeformation.NewLfTag(ctx, "example", &lakeformation.LfTagArgs{
 * 			Key: pulumi.String("right"),
 * 			Values: pulumi.StringArray{
 * 				pulumi.String("abbey"),
 * 				pulumi.String("village"),
 * 				pulumi.String("luffield"),
 * 				pulumi.String("woodcote"),
 * 				pulumi.String("copse"),
 * 				pulumi.String("chapel"),
 * 				pulumi.String("stowe"),
 * 				pulumi.String("club"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lakeformation.NewResourceLfTags(ctx, "example", &lakeformation.ResourceLfTagsArgs{
 * 			Database: &lakeformation.ResourceLfTagsDatabaseArgs{
 * 				Name: pulumi.Any(exampleAwsGlueCatalogDatabase.Name),
 * 			},
 * 			LfTags: lakeformation.ResourceLfTagsLfTagArray{
 * 				&lakeformation.ResourceLfTagsLfTagArgs{
 * 					Key:   example.Key,
 * 					Value: pulumi.String("stowe"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.LfTag;
 * import com.pulumi.aws.lakeformation.LfTagArgs;
 * import com.pulumi.aws.lakeformation.ResourceLfTags;
 * import com.pulumi.aws.lakeformation.ResourceLfTagsArgs;
 * import com.pulumi.aws.lakeformation.inputs.ResourceLfTagsDatabaseArgs;
 * import com.pulumi.aws.lakeformation.inputs.ResourceLfTagsLfTagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LfTag("example", LfTagArgs.builder()
 *             .key("right")
 *             .values(
 *                 "abbey",
 *                 "village",
 *                 "luffield",
 *                 "woodcote",
 *                 "copse",
 *                 "chapel",
 *                 "stowe",
 *                 "club")
 *             .build());
 *         var exampleResourceLfTags = new ResourceLfTags("exampleResourceLfTags", ResourceLfTagsArgs.builder()
 *             .database(ResourceLfTagsDatabaseArgs.builder()
 *                 .name(exampleAwsGlueCatalogDatabase.name())
 *                 .build())
 *             .lfTags(ResourceLfTagsLfTagArgs.builder()
 *                 .key(example.key())
 *                 .value("stowe")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lakeformation:LfTag
 *     properties:
 *       key: right
 *       values:
 *         - abbey
 *         - village
 *         - luffield
 *         - woodcote
 *         - copse
 *         - chapel
 *         - stowe
 *         - club
 *   exampleResourceLfTags:
 *     type: aws:lakeformation:ResourceLfTags
 *     name: example
 *     properties:
 *       database:
 *         name: ${exampleAwsGlueCatalogDatabase.name}
 *       lfTags:
 *         - key: ${example.key}
 *           value: stowe
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Multiple Tags Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lakeformation.LfTag("example", {
 *     key: "right",
 *     values: [
 *         "abbey",
 *         "village",
 *         "luffield",
 *         "woodcote",
 *         "copse",
 *         "chapel",
 *         "stowe",
 *         "club",
 *     ],
 * });
 * const example2 = new aws.lakeformation.LfTag("example2", {
 *     key: "left",
 *     values: [
 *         "farm",
 *         "theloop",
 *         "aintree",
 *         "brooklands",
 *         "maggotts",
 *         "becketts",
 *         "vale",
 *     ],
 * });
 * const exampleResourceLfTags = new aws.lakeformation.ResourceLfTags("example", {
 *     database: {
 *         name: exampleAwsGlueCatalogDatabase.name,
 *     },
 *     lfTags: [
 *         {
 *             key: "right",
 *             value: "luffield",
 *         },
 *         {
 *             key: "left",
 *             value: "aintree",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lakeformation.LfTag("example",
 *     key="right",
 *     values=[
 *         "abbey",
 *         "village",
 *         "luffield",
 *         "woodcote",
 *         "copse",
 *         "chapel",
 *         "stowe",
 *         "club",
 *     ])
 * example2 = aws.lakeformation.LfTag("example2",
 *     key="left",
 *     values=[
 *         "farm",
 *         "theloop",
 *         "aintree",
 *         "brooklands",
 *         "maggotts",
 *         "becketts",
 *         "vale",
 *     ])
 * example_resource_lf_tags = aws.lakeformation.ResourceLfTags("example",
 *     database={
 *         "name": example_aws_glue_catalog_database["name"],
 *     },
 *     lf_tags=[
 *         {
 *             "key": "right",
 *             "value": "luffield",
 *         },
 *         {
 *             "key": "left",
 *             "value": "aintree",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.LakeFormation.LfTag("example", new()
 *     {
 *         Key = "right",
 *         Values = new[]
 *         {
 *             "abbey",
 *             "village",
 *             "luffield",
 *             "woodcote",
 *             "copse",
 *             "chapel",
 *             "stowe",
 *             "club",
 *         },
 *     });
 *     var example2 = new Aws.LakeFormation.LfTag("example2", new()
 *     {
 *         Key = "left",
 *         Values = new[]
 *         {
 *             "farm",
 *             "theloop",
 *             "aintree",
 *             "brooklands",
 *             "maggotts",
 *             "becketts",
 *             "vale",
 *         },
 *     });
 *     var exampleResourceLfTags = new Aws.LakeFormation.ResourceLfTags("example", new()
 *     {
 *         Database = new Aws.LakeFormation.Inputs.ResourceLfTagsDatabaseArgs
 *         {
 *             Name = exampleAwsGlueCatalogDatabase.Name,
 *         },
 *         LfTags = new[]
 *         {
 *             new Aws.LakeFormation.Inputs.ResourceLfTagsLfTagArgs
 *             {
 *                 Key = "right",
 *                 Value = "luffield",
 *             },
 *             new Aws.LakeFormation.Inputs.ResourceLfTagsLfTagArgs
 *             {
 *                 Key = "left",
 *                 Value = "aintree",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lakeformation"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lakeformation.NewLfTag(ctx, "example", &lakeformation.LfTagArgs{
 * 			Key: pulumi.String("right"),
 * 			Values: pulumi.StringArray{
 * 				pulumi.String("abbey"),
 * 				pulumi.String("village"),
 * 				pulumi.String("luffield"),
 * 				pulumi.String("woodcote"),
 * 				pulumi.String("copse"),
 * 				pulumi.String("chapel"),
 * 				pulumi.String("stowe"),
 * 				pulumi.String("club"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lakeformation.NewLfTag(ctx, "example2", &lakeformation.LfTagArgs{
 * 			Key: pulumi.String("left"),
 * 			Values: pulumi.StringArray{
 * 				pulumi.String("farm"),
 * 				pulumi.String("theloop"),
 * 				pulumi.String("aintree"),
 * 				pulumi.String("brooklands"),
 * 				pulumi.String("maggotts"),
 * 				pulumi.String("becketts"),
 * 				pulumi.String("vale"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lakeformation.NewResourceLfTags(ctx, "example", &lakeformation.ResourceLfTagsArgs{
 * 			Database: &lakeformation.ResourceLfTagsDatabaseArgs{
 * 				Name: pulumi.Any(exampleAwsGlueCatalogDatabase.Name),
 * 			},
 * 			LfTags: lakeformation.ResourceLfTagsLfTagArray{
 * 				&lakeformation.ResourceLfTagsLfTagArgs{
 * 					Key:   pulumi.String("right"),
 * 					Value: pulumi.String("luffield"),
 * 				},
 * 				&lakeformation.ResourceLfTagsLfTagArgs{
 * 					Key:   pulumi.String("left"),
 * 					Value: pulumi.String("aintree"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.LfTag;
 * import com.pulumi.aws.lakeformation.LfTagArgs;
 * import com.pulumi.aws.lakeformation.ResourceLfTags;
 * import com.pulumi.aws.lakeformation.ResourceLfTagsArgs;
 * import com.pulumi.aws.lakeformation.inputs.ResourceLfTagsDatabaseArgs;
 * import com.pulumi.aws.lakeformation.inputs.ResourceLfTagsLfTagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LfTag("example", LfTagArgs.builder()
 *             .key("right")
 *             .values(
 *                 "abbey",
 *                 "village",
 *                 "luffield",
 *                 "woodcote",
 *                 "copse",
 *                 "chapel",
 *                 "stowe",
 *                 "club")
 *             .build());
 *         var example2 = new LfTag("example2", LfTagArgs.builder()
 *             .key("left")
 *             .values(
 *                 "farm",
 *                 "theloop",
 *                 "aintree",
 *                 "brooklands",
 *                 "maggotts",
 *                 "becketts",
 *                 "vale")
 *             .build());
 *         var exampleResourceLfTags = new ResourceLfTags("exampleResourceLfTags", ResourceLfTagsArgs.builder()
 *             .database(ResourceLfTagsDatabaseArgs.builder()
 *                 .name(exampleAwsGlueCatalogDatabase.name())
 *                 .build())
 *             .lfTags(
 *                 ResourceLfTagsLfTagArgs.builder()
 *                     .key("right")
 *                     .value("luffield")
 *                     .build(),
 *                 ResourceLfTagsLfTagArgs.builder()
 *                     .key("left")
 *                     .value("aintree")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lakeformation:LfTag
 *     properties:
 *       key: right
 *       values:
 *         - abbey
 *         - village
 *         - luffield
 *         - woodcote
 *         - copse
 *         - chapel
 *         - stowe
 *         - club
 *   example2:
 *     type: aws:lakeformation:LfTag
 *     properties:
 *       key: left
 *       values:
 *         - farm
 *         - theloop
 *         - aintree
 *         - brooklands
 *         - maggotts
 *         - becketts
 *         - vale
 *   exampleResourceLfTags:
 *     type: aws:lakeformation:ResourceLfTags
 *     name: example
 *     properties:
 *       database:
 *         name: ${exampleAwsGlueCatalogDatabase.name}
 *       lfTags:
 *         - key: right
 *           value: luffield
 *         - key: left
 *           value: aintree
 * ```
 * <!--End PulumiCodeChooser -->
 * @property catalogId Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
 * @property database Configuration block for a database resource. See below.
 * @property lfTags Set of LF-tags to attach to the resource. See below.
 * Exactly one of the following is required:
 * @property table Configuration block for a table resource. See below.
 * @property tableWithColumns Configuration block for a table with columns resource. See below.
 * The following arguments are optional:
 */
public data class ResourceLfTagsArgs(
    public val catalogId: Output<String>? = null,
    public val database: Output<ResourceLfTagsDatabaseArgs>? = null,
    public val lfTags: Output<List<ResourceLfTagsLfTagArgs>>? = null,
    public val table: Output<ResourceLfTagsTableArgs>? = null,
    public val tableWithColumns: Output<ResourceLfTagsTableWithColumnsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.ResourceLfTagsArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.ResourceLfTagsArgs =
        com.pulumi.aws.lakeformation.ResourceLfTagsArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .database(database?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .lfTags(lfTags?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .table(table?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tableWithColumns(
                tableWithColumns?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ResourceLfTagsArgs].
 */
@PulumiTagMarker
public class ResourceLfTagsArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var database: Output<ResourceLfTagsDatabaseArgs>? = null

    private var lfTags: Output<List<ResourceLfTagsLfTagArgs>>? = null

    private var table: Output<ResourceLfTagsTableArgs>? = null

    private var tableWithColumns: Output<ResourceLfTagsTableWithColumnsArgs>? = null

    /**
     * @param value Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
     */
    @JvmName("xojsxuegtgbjqlul")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value Configuration block for a database resource. See below.
     */
    @JvmName("nhcbgggkmmasdbuc")
    public suspend fun database(`value`: Output<ResourceLfTagsDatabaseArgs>) {
        this.database = value
    }

    /**
     * @param value Set of LF-tags to attach to the resource. See below.
     * Exactly one of the following is required:
     */
    @JvmName("efrrpkbhcwhhcram")
    public suspend fun lfTags(`value`: Output<List<ResourceLfTagsLfTagArgs>>) {
        this.lfTags = value
    }

    @JvmName("xsnugctgimmkwgri")
    public suspend fun lfTags(vararg values: Output<ResourceLfTagsLfTagArgs>) {
        this.lfTags = Output.all(values.asList())
    }

    /**
     * @param values Set of LF-tags to attach to the resource. See below.
     * Exactly one of the following is required:
     */
    @JvmName("uhjxrosleyrurccd")
    public suspend fun lfTags(values: List<Output<ResourceLfTagsLfTagArgs>>) {
        this.lfTags = Output.all(values)
    }

    /**
     * @param value Configuration block for a table resource. See below.
     */
    @JvmName("rildegtawdnljxjm")
    public suspend fun table(`value`: Output<ResourceLfTagsTableArgs>) {
        this.table = value
    }

    /**
     * @param value Configuration block for a table with columns resource. See below.
     * The following arguments are optional:
     */
    @JvmName("doiiygoqjausgbaa")
    public suspend fun tableWithColumns(`value`: Output<ResourceLfTagsTableWithColumnsArgs>) {
        this.tableWithColumns = value
    }

    /**
     * @param value Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
     */
    @JvmName("oxonrktvshfpwcre")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value Configuration block for a database resource. See below.
     */
    @JvmName("ybcfotgvescycltx")
    public suspend fun database(`value`: ResourceLfTagsDatabaseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param argument Configuration block for a database resource. See below.
     */
    @JvmName("ikhvlfpsyrhawyva")
    public suspend fun database(argument: suspend ResourceLfTagsDatabaseArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceLfTagsDatabaseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.database = mapped
    }

    /**
     * @param value Set of LF-tags to attach to the resource. See below.
     * Exactly one of the following is required:
     */
    @JvmName("bogxobpuqhyflktd")
    public suspend fun lfTags(`value`: List<ResourceLfTagsLfTagArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lfTags = mapped
    }

    /**
     * @param argument Set of LF-tags to attach to the resource. See below.
     * Exactly one of the following is required:
     */
    @JvmName("camjkrlhiksqmgjk")
    public suspend fun lfTags(argument: List<suspend ResourceLfTagsLfTagArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceLfTagsLfTagArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lfTags = mapped
    }

    /**
     * @param argument Set of LF-tags to attach to the resource. See below.
     * Exactly one of the following is required:
     */
    @JvmName("mbugdficoqirtojl")
    public suspend fun lfTags(vararg argument: suspend ResourceLfTagsLfTagArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ResourceLfTagsLfTagArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lfTags = mapped
    }

    /**
     * @param argument Set of LF-tags to attach to the resource. See below.
     * Exactly one of the following is required:
     */
    @JvmName("xjjxycqlvgeotxvc")
    public suspend fun lfTags(argument: suspend ResourceLfTagsLfTagArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceLfTagsLfTagArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.lfTags = mapped
    }

    /**
     * @param values Set of LF-tags to attach to the resource. See below.
     * Exactly one of the following is required:
     */
    @JvmName("qyqnsdeafpysamyk")
    public suspend fun lfTags(vararg values: ResourceLfTagsLfTagArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lfTags = mapped
    }

    /**
     * @param value Configuration block for a table resource. See below.
     */
    @JvmName("crpmaamygfqlcryj")
    public suspend fun table(`value`: ResourceLfTagsTableArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.table = mapped
    }

    /**
     * @param argument Configuration block for a table resource. See below.
     */
    @JvmName("egnhewjwpceiodbq")
    public suspend fun table(argument: suspend ResourceLfTagsTableArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceLfTagsTableArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.table = mapped
    }

    /**
     * @param value Configuration block for a table with columns resource. See below.
     * The following arguments are optional:
     */
    @JvmName("wetfhadxpcssdguh")
    public suspend fun tableWithColumns(`value`: ResourceLfTagsTableWithColumnsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableWithColumns = mapped
    }

    /**
     * @param argument Configuration block for a table with columns resource. See below.
     * The following arguments are optional:
     */
    @JvmName("wdewgsleosgiykgs")
    public suspend fun tableWithColumns(argument: suspend ResourceLfTagsTableWithColumnsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceLfTagsTableWithColumnsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tableWithColumns = mapped
    }

    internal fun build(): ResourceLfTagsArgs = ResourceLfTagsArgs(
        catalogId = catalogId,
        database = database,
        lfTags = lfTags,
        table = table,
        tableWithColumns = tableWithColumns,
    )
}
