@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.DataCellsFilterTableDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property columnNames A list of column names and/or nested column attributes.
 * @property columnWildcard A wildcard with exclusions. See Column Wildcard below for details.
 * @property databaseName The name of the database.
 * @property name The name of the data cells filter.
 * @property rowFilter A PartiQL predicate. See Row Filter below for details.
 * @property tableCatalogId The ID of the Data Catalog.
 * @property tableName The name of the table.
 * @property versionId ID of the data cells filter version.
 */
public data class DataCellsFilterTableDataArgs(
    public val columnNames: Output<List<String>>? = null,
    public val columnWildcard: Output<DataCellsFilterTableDataColumnWildcardArgs>? = null,
    public val databaseName: Output<String>,
    public val name: Output<String>,
    public val rowFilter: Output<DataCellsFilterTableDataRowFilterArgs>? = null,
    public val tableCatalogId: Output<String>,
    public val tableName: Output<String>,
    public val versionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.DataCellsFilterTableDataArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.DataCellsFilterTableDataArgs =
        com.pulumi.aws.lakeformation.inputs.DataCellsFilterTableDataArgs.builder()
            .columnNames(columnNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .columnWildcard(columnWildcard?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .databaseName(databaseName.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .rowFilter(rowFilter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tableCatalogId(tableCatalogId.applyValue({ args0 -> args0 }))
            .tableName(tableName.applyValue({ args0 -> args0 }))
            .versionId(versionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataCellsFilterTableDataArgs].
 */
@PulumiTagMarker
public class DataCellsFilterTableDataArgsBuilder internal constructor() {
    private var columnNames: Output<List<String>>? = null

    private var columnWildcard: Output<DataCellsFilterTableDataColumnWildcardArgs>? = null

    private var databaseName: Output<String>? = null

    private var name: Output<String>? = null

    private var rowFilter: Output<DataCellsFilterTableDataRowFilterArgs>? = null

    private var tableCatalogId: Output<String>? = null

    private var tableName: Output<String>? = null

    private var versionId: Output<String>? = null

    /**
     * @param value A list of column names and/or nested column attributes.
     */
    @JvmName("rlrkxladkpcjserm")
    public suspend fun columnNames(`value`: Output<List<String>>) {
        this.columnNames = value
    }

    @JvmName("mvqenrqgdtyiyisu")
    public suspend fun columnNames(vararg values: Output<String>) {
        this.columnNames = Output.all(values.asList())
    }

    /**
     * @param values A list of column names and/or nested column attributes.
     */
    @JvmName("gmolapewfkiirgva")
    public suspend fun columnNames(values: List<Output<String>>) {
        this.columnNames = Output.all(values)
    }

    /**
     * @param value A wildcard with exclusions. See Column Wildcard below for details.
     */
    @JvmName("trbdymblwgvdsscj")
    public suspend fun columnWildcard(`value`: Output<DataCellsFilterTableDataColumnWildcardArgs>) {
        this.columnWildcard = value
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("oeomninavkupcajm")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The name of the data cells filter.
     */
    @JvmName("nqlxyswftfkqkylv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A PartiQL predicate. See Row Filter below for details.
     */
    @JvmName("uqvgtibyskhpabpt")
    public suspend fun rowFilter(`value`: Output<DataCellsFilterTableDataRowFilterArgs>) {
        this.rowFilter = value
    }

    /**
     * @param value The ID of the Data Catalog.
     */
    @JvmName("syubkjvxbtpyqfip")
    public suspend fun tableCatalogId(`value`: Output<String>) {
        this.tableCatalogId = value
    }

    /**
     * @param value The name of the table.
     */
    @JvmName("prrcncacccsjctbt")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value ID of the data cells filter version.
     */
    @JvmName("efcmdqwschoaiaqr")
    public suspend fun versionId(`value`: Output<String>) {
        this.versionId = value
    }

    /**
     * @param value A list of column names and/or nested column attributes.
     */
    @JvmName("vruioxdmbvtprhel")
    public suspend fun columnNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columnNames = mapped
    }

    /**
     * @param values A list of column names and/or nested column attributes.
     */
    @JvmName("jppbgixdnkjbkrps")
    public suspend fun columnNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columnNames = mapped
    }

    /**
     * @param value A wildcard with exclusions. See Column Wildcard below for details.
     */
    @JvmName("saudnhwgaawfgvrf")
    public suspend fun columnWildcard(`value`: DataCellsFilterTableDataColumnWildcardArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columnWildcard = mapped
    }

    /**
     * @param argument A wildcard with exclusions. See Column Wildcard below for details.
     */
    @JvmName("hqxknivqklnmywod")
    public suspend fun columnWildcard(argument: suspend DataCellsFilterTableDataColumnWildcardArgsBuilder.() -> Unit) {
        val toBeMapped = DataCellsFilterTableDataColumnWildcardArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.columnWildcard = mapped
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("jemtyolsjaddjsus")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the data cells filter.
     */
    @JvmName("twsehvakhmfdjrrm")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A PartiQL predicate. See Row Filter below for details.
     */
    @JvmName("omhitvbkepmmdilr")
    public suspend fun rowFilter(`value`: DataCellsFilterTableDataRowFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rowFilter = mapped
    }

    /**
     * @param argument A PartiQL predicate. See Row Filter below for details.
     */
    @JvmName("mlxseyhufmihamrj")
    public suspend fun rowFilter(argument: suspend DataCellsFilterTableDataRowFilterArgsBuilder.() -> Unit) {
        val toBeMapped = DataCellsFilterTableDataRowFilterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rowFilter = mapped
    }

    /**
     * @param value The ID of the Data Catalog.
     */
    @JvmName("cmaohxganpuonvtv")
    public suspend fun tableCatalogId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableCatalogId = mapped
    }

    /**
     * @param value The name of the table.
     */
    @JvmName("vypcpbmmknuykvfd")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    /**
     * @param value ID of the data cells filter version.
     */
    @JvmName("jhgtrplcbsyfvmvv")
    public suspend fun versionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionId = mapped
    }

    internal fun build(): DataCellsFilterTableDataArgs = DataCellsFilterTableDataArgs(
        columnNames = columnNames,
        columnWildcard = columnWildcard,
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        name = name ?: throw PulumiNullFieldException("name"),
        rowFilter = rowFilter,
        tableCatalogId = tableCatalogId ?: throw PulumiNullFieldException("tableCatalogId"),
        tableName = tableName ?: throw PulumiNullFieldException("tableName"),
        versionId = versionId,
    )
}
