@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.DataCellsFilterTableDataColumnWildcardArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property excludedColumnNames (Optional) Excludes column names. Any column with this name will be excluded.
 */
public data class DataCellsFilterTableDataColumnWildcardArgs(
    public val excludedColumnNames: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.DataCellsFilterTableDataColumnWildcardArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.DataCellsFilterTableDataColumnWildcardArgs =
        com.pulumi.aws.lakeformation.inputs.DataCellsFilterTableDataColumnWildcardArgs.builder()
            .excludedColumnNames(
                excludedColumnNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [DataCellsFilterTableDataColumnWildcardArgs].
 */
@PulumiTagMarker
public class DataCellsFilterTableDataColumnWildcardArgsBuilder internal constructor() {
    private var excludedColumnNames: Output<List<String>>? = null

    /**
     * @param value (Optional) Excludes column names. Any column with this name will be excluded.
     */
    @JvmName("dtuvacexbmaaokbj")
    public suspend fun excludedColumnNames(`value`: Output<List<String>>) {
        this.excludedColumnNames = value
    }

    @JvmName("bithdgrnpirychtv")
    public suspend fun excludedColumnNames(vararg values: Output<String>) {
        this.excludedColumnNames = Output.all(values.asList())
    }

    /**
     * @param values (Optional) Excludes column names. Any column with this name will be excluded.
     */
    @JvmName("xgdhetjlpqeyhhdk")
    public suspend fun excludedColumnNames(values: List<Output<String>>) {
        this.excludedColumnNames = Output.all(values)
    }

    /**
     * @param value (Optional) Excludes column names. Any column with this name will be excluded.
     */
    @JvmName("lsvtkqysxhalfhjm")
    public suspend fun excludedColumnNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedColumnNames = mapped
    }

    /**
     * @param values (Optional) Excludes column names. Any column with this name will be excluded.
     */
    @JvmName("lcchebtxbfenqmyl")
    public suspend fun excludedColumnNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedColumnNames = mapped
    }

    internal fun build(): DataCellsFilterTableDataColumnWildcardArgs =
        DataCellsFilterTableDataColumnWildcardArgs(
            excludedColumnNames = excludedColumnNames,
        )
}
