@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.DataCellsFilterTableDataRowFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property allRowsWildcard (Optional) A wildcard that matches all rows.
 * @property filterExpression (Optional) A filter expression.
 */
public data class DataCellsFilterTableDataRowFilterArgs(
    public val allRowsWildcard: Output<DataCellsFilterTableDataRowFilterAllRowsWildcardArgs>? = null,
    public val filterExpression: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.DataCellsFilterTableDataRowFilterArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.DataCellsFilterTableDataRowFilterArgs =
        com.pulumi.aws.lakeformation.inputs.DataCellsFilterTableDataRowFilterArgs.builder()
            .allRowsWildcard(allRowsWildcard?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .filterExpression(filterExpression?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataCellsFilterTableDataRowFilterArgs].
 */
@PulumiTagMarker
public class DataCellsFilterTableDataRowFilterArgsBuilder internal constructor() {
    private var allRowsWildcard: Output<DataCellsFilterTableDataRowFilterAllRowsWildcardArgs>? = null

    private var filterExpression: Output<String>? = null

    /**
     * @param value (Optional) A wildcard that matches all rows.
     */
    @JvmName("fkpkjudiyjnjjljj")
    public suspend fun allRowsWildcard(`value`: Output<DataCellsFilterTableDataRowFilterAllRowsWildcardArgs>) {
        this.allRowsWildcard = value
    }

    /**
     * @param value (Optional) A filter expression.
     */
    @JvmName("osorvuektoxovium")
    public suspend fun filterExpression(`value`: Output<String>) {
        this.filterExpression = value
    }

    /**
     * @param value (Optional) A wildcard that matches all rows.
     */
    @JvmName("tpercmrksyvqhwpg")
    public suspend fun allRowsWildcard(`value`: DataCellsFilterTableDataRowFilterAllRowsWildcardArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allRowsWildcard = mapped
    }

    /**
     * @param argument (Optional) A wildcard that matches all rows.
     */
    @JvmName("cjfiktirhfpeuxpw")
    public suspend fun allRowsWildcard(argument: suspend DataCellsFilterTableDataRowFilterAllRowsWildcardArgsBuilder.() -> Unit) {
        val toBeMapped = DataCellsFilterTableDataRowFilterAllRowsWildcardArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.allRowsWildcard = mapped
    }

    /**
     * @param value (Optional) A filter expression.
     */
    @JvmName("qcxsymtjogjooqun")
    public suspend fun filterExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterExpression = mapped
    }

    internal fun build(): DataCellsFilterTableDataRowFilterArgs =
        DataCellsFilterTableDataRowFilterArgs(
            allRowsWildcard = allRowsWildcard,
            filterExpression = filterExpression,
        )
}
