@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.DataLakeSettingsCreateDatabaseDefaultPermissionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property permissions List of permissions that are granted to the principal. Valid values may include `ALL`, `SELECT`, `ALTER`, `DROP`, `DELETE`, `INSERT`, `DESCRIBE`, and `CREATE_TABLE`. For more details, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
 * @property principal Principal who is granted permissions. To enforce metadata and underlying data access control only by IAM on new databases and tables set `principal` to `IAM_ALLOWED_PRINCIPALS` and `permissions` to `["ALL"]`.
 */
public data class DataLakeSettingsCreateDatabaseDefaultPermissionArgs(
    public val permissions: Output<List<String>>? = null,
    public val principal: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.DataLakeSettingsCreateDatabaseDefaultPermissionArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.DataLakeSettingsCreateDatabaseDefaultPermissionArgs =
        com.pulumi.aws.lakeformation.inputs.DataLakeSettingsCreateDatabaseDefaultPermissionArgs.builder()
            .permissions(permissions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .principal(principal?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataLakeSettingsCreateDatabaseDefaultPermissionArgs].
 */
@PulumiTagMarker
public class DataLakeSettingsCreateDatabaseDefaultPermissionArgsBuilder internal constructor() {
    private var permissions: Output<List<String>>? = null

    private var principal: Output<String>? = null

    /**
     * @param value List of permissions that are granted to the principal. Valid values may include `ALL`, `SELECT`, `ALTER`, `DROP`, `DELETE`, `INSERT`, `DESCRIBE`, and `CREATE_TABLE`. For more details, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
     */
    @JvmName("tsyacfbwxeyqqpov")
    public suspend fun permissions(`value`: Output<List<String>>) {
        this.permissions = value
    }

    @JvmName("avbdtlqatpoqxrod")
    public suspend fun permissions(vararg values: Output<String>) {
        this.permissions = Output.all(values.asList())
    }

    /**
     * @param values List of permissions that are granted to the principal. Valid values may include `ALL`, `SELECT`, `ALTER`, `DROP`, `DELETE`, `INSERT`, `DESCRIBE`, and `CREATE_TABLE`. For more details, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
     */
    @JvmName("vrqtoqmkpixxeihy")
    public suspend fun permissions(values: List<Output<String>>) {
        this.permissions = Output.all(values)
    }

    /**
     * @param value Principal who is granted permissions. To enforce metadata and underlying data access control only by IAM on new databases and tables set `principal` to `IAM_ALLOWED_PRINCIPALS` and `permissions` to `["ALL"]`.
     */
    @JvmName("axwakykbsfwjlnlo")
    public suspend fun principal(`value`: Output<String>) {
        this.principal = value
    }

    /**
     * @param value List of permissions that are granted to the principal. Valid values may include `ALL`, `SELECT`, `ALTER`, `DROP`, `DELETE`, `INSERT`, `DESCRIBE`, and `CREATE_TABLE`. For more details, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
     */
    @JvmName("fnhloxrqstrsbwqb")
    public suspend fun permissions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param values List of permissions that are granted to the principal. Valid values may include `ALL`, `SELECT`, `ALTER`, `DROP`, `DELETE`, `INSERT`, `DESCRIBE`, and `CREATE_TABLE`. For more details, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
     */
    @JvmName("pefnsvigmsvnglwn")
    public suspend fun permissions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value Principal who is granted permissions. To enforce metadata and underlying data access control only by IAM on new databases and tables set `principal` to `IAM_ALLOWED_PRINCIPALS` and `permissions` to `["ALL"]`.
     */
    @JvmName("nodeompjlpgnhjxs")
    public suspend fun principal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principal = mapped
    }

    internal fun build(): DataLakeSettingsCreateDatabaseDefaultPermissionArgs =
        DataLakeSettingsCreateDatabaseDefaultPermissionArgs(
            permissions = permissions,
            principal = principal,
        )
}
