@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.GetDataLakeSettingsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDataLakeSettings.
 * @property catalogId Identifier for the Data Catalog. By default, the account ID.
 */
public data class GetDataLakeSettingsPlainArgs(
    public val catalogId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.GetDataLakeSettingsPlainArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.GetDataLakeSettingsPlainArgs =
        com.pulumi.aws.lakeformation.inputs.GetDataLakeSettingsPlainArgs.builder()
            .catalogId(catalogId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDataLakeSettingsPlainArgs].
 */
@PulumiTagMarker
public class GetDataLakeSettingsPlainArgsBuilder internal constructor() {
    private var catalogId: String? = null

    /**
     * @param value Identifier for the Data Catalog. By default, the account ID.
     */
    @JvmName("xyostveoanffaibt")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.catalogId = mapped
    }

    internal fun build(): GetDataLakeSettingsPlainArgs = GetDataLakeSettingsPlainArgs(
        catalogId = catalogId,
    )
}
