@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.GetPermissionsDataCellsFilter.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property databaseName The name of the database.
 * @property name The name of the data cells filter.
 * @property tableCatalogId The ID of the Data Catalog.
 * @property tableName The name of the table.
 */
public data class GetPermissionsDataCellsFilter(
    public val databaseName: String,
    public val name: String,
    public val tableCatalogId: String,
    public val tableName: String,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.GetPermissionsDataCellsFilter> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.GetPermissionsDataCellsFilter =
        com.pulumi.aws.lakeformation.inputs.GetPermissionsDataCellsFilter.builder()
            .databaseName(databaseName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .tableCatalogId(tableCatalogId.let({ args0 -> args0 }))
            .tableName(tableName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPermissionsDataCellsFilter].
 */
@PulumiTagMarker
public class GetPermissionsDataCellsFilterBuilder internal constructor() {
    private var databaseName: String? = null

    private var name: String? = null

    private var tableCatalogId: String? = null

    private var tableName: String? = null

    /**
     * @param value The name of the database.
     */
    @JvmName("biysypxepxoogmbc")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the data cells filter.
     */
    @JvmName("lhnuhovhghxwpofh")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The ID of the Data Catalog.
     */
    @JvmName("ixskwlyqydnpquup")
    public suspend fun tableCatalogId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tableCatalogId = mapped
    }

    /**
     * @param value The name of the table.
     */
    @JvmName("gjhjhcscwdjtjrpj")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tableName = mapped
    }

    internal fun build(): GetPermissionsDataCellsFilter = GetPermissionsDataCellsFilter(
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        name = name ?: throw PulumiNullFieldException("name"),
        tableCatalogId = tableCatalogId ?: throw PulumiNullFieldException("tableCatalogId"),
        tableName = tableName ?: throw PulumiNullFieldException("tableName"),
    )
}
