@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.GetPermissionsLfTag.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property catalogId Identifier for the Data Catalog. By default, it is the account ID of the caller.
 * @property key Key-name for the tag.
 * @property values List of possible values an attribute can take.
 * The following argument is optional:
 */
public data class GetPermissionsLfTag(
    public val catalogId: String,
    public val key: String,
    public val values: List<String>,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.GetPermissionsLfTag> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.GetPermissionsLfTag =
        com.pulumi.aws.lakeformation.inputs.GetPermissionsLfTag.builder()
            .catalogId(catalogId.let({ args0 -> args0 }))
            .key(key.let({ args0 -> args0 }))
            .values(values.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetPermissionsLfTag].
 */
@PulumiTagMarker
public class GetPermissionsLfTagBuilder internal constructor() {
    private var catalogId: String? = null

    private var key: String? = null

    private var values: List<String>? = null

    /**
     * @param value Identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    @JvmName("pgfteputgvlequdb")
    public suspend fun catalogId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.catalogId = mapped
    }

    /**
     * @param value Key-name for the tag.
     */
    @JvmName("mhlnwfphimfaadrd")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.key = mapped
    }

    /**
     * @param value List of possible values an attribute can take.
     * The following argument is optional:
     */
    @JvmName("orbgqejladluvodp")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values List of possible values an attribute can take.
     * The following argument is optional:
     */
    @JvmName("buxyastruddsnans")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    internal fun build(): GetPermissionsLfTag = GetPermissionsLfTag(
        catalogId = catalogId ?: throw PulumiNullFieldException("catalogId"),
        key = key ?: throw PulumiNullFieldException("key"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
