@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.GetPermissionsLfTagPolicy.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property catalogId Identifier for the Data Catalog. By default, it is the account ID of the caller.
 * @property expressions List of tag conditions that apply to the resource's tag policy. Configuration block for tag conditions that apply to the policy. See `expression` below.
 * The following argument is optional:
 * @property resourceType Resource type for which the tag policy applies. Valid values are `DATABASE` and `TABLE`.
 */
public data class GetPermissionsLfTagPolicy(
    public val catalogId: String,
    public val expressions: List<GetPermissionsLfTagPolicyExpression>,
    public val resourceType: String,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.GetPermissionsLfTagPolicy> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.GetPermissionsLfTagPolicy =
        com.pulumi.aws.lakeformation.inputs.GetPermissionsLfTagPolicy.builder()
            .catalogId(catalogId.let({ args0 -> args0 }))
            .expressions(
                expressions.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceType(resourceType.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPermissionsLfTagPolicy].
 */
@PulumiTagMarker
public class GetPermissionsLfTagPolicyBuilder internal constructor() {
    private var catalogId: String? = null

    private var expressions: List<GetPermissionsLfTagPolicyExpression>? = null

    private var resourceType: String? = null

    /**
     * @param value Identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    @JvmName("vegbfegkpnstjelk")
    public suspend fun catalogId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.catalogId = mapped
    }

    /**
     * @param value List of tag conditions that apply to the resource's tag policy. Configuration block for tag conditions that apply to the policy. See `expression` below.
     * The following argument is optional:
     */
    @JvmName("ytexyrugkhnqypgm")
    public suspend fun expressions(`value`: List<GetPermissionsLfTagPolicyExpression>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.expressions = mapped
    }

    /**
     * @param argument List of tag conditions that apply to the resource's tag policy. Configuration block for tag conditions that apply to the policy. See `expression` below.
     * The following argument is optional:
     */
    @JvmName("wkmqyveueuuvxbck")
    public suspend fun expressions(argument: List<suspend GetPermissionsLfTagPolicyExpressionBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetPermissionsLfTagPolicyExpressionBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.expressions = mapped
    }

    /**
     * @param argument List of tag conditions that apply to the resource's tag policy. Configuration block for tag conditions that apply to the policy. See `expression` below.
     * The following argument is optional:
     */
    @JvmName("qhywbylcrmierloe")
    public suspend fun expressions(vararg argument: suspend GetPermissionsLfTagPolicyExpressionBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetPermissionsLfTagPolicyExpressionBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.expressions = mapped
    }

    /**
     * @param argument List of tag conditions that apply to the resource's tag policy. Configuration block for tag conditions that apply to the policy. See `expression` below.
     * The following argument is optional:
     */
    @JvmName("dglkchvppnohwsjc")
    public suspend fun expressions(argument: suspend GetPermissionsLfTagPolicyExpressionBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetPermissionsLfTagPolicyExpressionBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.expressions = mapped
    }

    /**
     * @param values List of tag conditions that apply to the resource's tag policy. Configuration block for tag conditions that apply to the policy. See `expression` below.
     * The following argument is optional:
     */
    @JvmName("maaofnxieuwkafag")
    public suspend fun expressions(vararg values: GetPermissionsLfTagPolicyExpression) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.expressions = mapped
    }

    /**
     * @param value Resource type for which the tag policy applies. Valid values are `DATABASE` and `TABLE`.
     */
    @JvmName("liopcvultbjjpbsf")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceType = mapped
    }

    internal fun build(): GetPermissionsLfTagPolicy = GetPermissionsLfTagPolicy(
        catalogId = catalogId ?: throw PulumiNullFieldException("catalogId"),
        expressions = expressions ?: throw PulumiNullFieldException("expressions"),
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
    )
}
