@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.PermissionsDataCellsFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property databaseName The name of the database.
 * @property name The name of the data cells filter.
 * @property tableCatalogId The ID of the Data Catalog.
 * @property tableName The name of the table.
 */
public data class PermissionsDataCellsFilterArgs(
    public val databaseName: Output<String>,
    public val name: Output<String>,
    public val tableCatalogId: Output<String>,
    public val tableName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.PermissionsDataCellsFilterArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.PermissionsDataCellsFilterArgs =
        com.pulumi.aws.lakeformation.inputs.PermissionsDataCellsFilterArgs.builder()
            .databaseName(databaseName.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .tableCatalogId(tableCatalogId.applyValue({ args0 -> args0 }))
            .tableName(tableName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PermissionsDataCellsFilterArgs].
 */
@PulumiTagMarker
public class PermissionsDataCellsFilterArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var name: Output<String>? = null

    private var tableCatalogId: Output<String>? = null

    private var tableName: Output<String>? = null

    /**
     * @param value The name of the database.
     */
    @JvmName("dttipfxcnbotmfwv")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The name of the data cells filter.
     */
    @JvmName("bwcusxobegjmdakj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ID of the Data Catalog.
     */
    @JvmName("eaytamsyvgwyyfds")
    public suspend fun tableCatalogId(`value`: Output<String>) {
        this.tableCatalogId = value
    }

    /**
     * @param value The name of the table.
     */
    @JvmName("ckougciicfhpdxyf")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("xpajyyypwhpxnoic")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the data cells filter.
     */
    @JvmName("gatnrxowwpwseogp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ID of the Data Catalog.
     */
    @JvmName("urgbpbkesbcfeueq")
    public suspend fun tableCatalogId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableCatalogId = mapped
    }

    /**
     * @param value The name of the table.
     */
    @JvmName("gwtayenlgimkiwki")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): PermissionsDataCellsFilterArgs = PermissionsDataCellsFilterArgs(
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        name = name ?: throw PulumiNullFieldException("name"),
        tableCatalogId = tableCatalogId ?: throw PulumiNullFieldException("tableCatalogId"),
        tableName = tableName ?: throw PulumiNullFieldException("tableName"),
    )
}
