@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.PermissionsDataLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn Amazon Resource Name (ARN) that uniquely identifies the data location resource.
 * The following argument is optional:
 * @property catalogId Identifier for the Data Catalog where the location is registered with Lake Formation. By default, it is the account ID of the caller.
 */
public data class PermissionsDataLocationArgs(
    public val arn: Output<String>,
    public val catalogId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.PermissionsDataLocationArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.PermissionsDataLocationArgs =
        com.pulumi.aws.lakeformation.inputs.PermissionsDataLocationArgs.builder()
            .arn(arn.applyValue({ args0 -> args0 }))
            .catalogId(catalogId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PermissionsDataLocationArgs].
 */
@PulumiTagMarker
public class PermissionsDataLocationArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var catalogId: Output<String>? = null

    /**
     * @param value Amazon Resource Name (ARN) that uniquely identifies the data location resource.
     * The following argument is optional:
     */
    @JvmName("ditasgcljoctmioh")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value Identifier for the Data Catalog where the location is registered with Lake Formation. By default, it is the account ID of the caller.
     */
    @JvmName("kbewvcegxbbqdqmn")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value Amazon Resource Name (ARN) that uniquely identifies the data location resource.
     * The following argument is optional:
     */
    @JvmName("qkbvphfatiodssvm")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value Identifier for the Data Catalog where the location is registered with Lake Formation. By default, it is the account ID of the caller.
     */
    @JvmName("cqqesleflprfshyx")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    internal fun build(): PermissionsDataLocationArgs = PermissionsDataLocationArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
        catalogId = catalogId,
    )
}
