@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.PermissionsDatabaseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogId Identifier for the Data Catalog. By default, it is the account ID of the caller.
 * @property name Name of the database resource. Unique to the Data Catalog.
 * The following argument is optional:
 */
public data class PermissionsDatabaseArgs(
    public val catalogId: Output<String>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.PermissionsDatabaseArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.PermissionsDatabaseArgs =
        com.pulumi.aws.lakeformation.inputs.PermissionsDatabaseArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PermissionsDatabaseArgs].
 */
@PulumiTagMarker
public class PermissionsDatabaseArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    @JvmName("mbcldfdcceuxjurf")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value Name of the database resource. Unique to the Data Catalog.
     * The following argument is optional:
     */
    @JvmName("fehaylincvtdlhbr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    @JvmName("edqxmqrfftlanwtx")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value Name of the database resource. Unique to the Data Catalog.
     * The following argument is optional:
     */
    @JvmName("mjsikequyleludfg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): PermissionsDatabaseArgs = PermissionsDatabaseArgs(
        catalogId = catalogId,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
