@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.PermissionsLfTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property catalogId Identifier for the Data Catalog. By default, it is the account ID of the caller.
 * @property key The key-name for the tag.
 * @property values A list of possible values an attribute can take.
 * The following argument is optional:
 */
public data class PermissionsLfTagArgs(
    public val catalogId: Output<String>? = null,
    public val key: Output<String>,
    public val values: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.PermissionsLfTagArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.PermissionsLfTagArgs =
        com.pulumi.aws.lakeformation.inputs.PermissionsLfTagArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .key(key.applyValue({ args0 -> args0 }))
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PermissionsLfTagArgs].
 */
@PulumiTagMarker
public class PermissionsLfTagArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var key: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value Identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    @JvmName("eoeesqpsorqtufax")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value The key-name for the tag.
     */
    @JvmName("qypnjgewyjfijvsa")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value A list of possible values an attribute can take.
     * The following argument is optional:
     */
    @JvmName("drnqycheovynavya")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("yatnlhscfsdmmcgr")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values A list of possible values an attribute can take.
     * The following argument is optional:
     */
    @JvmName("owtqgiwbrvwoiche")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value Identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    @JvmName("olufwufrotjmaooj")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value The key-name for the tag.
     */
    @JvmName("utajwodltbrdtrmc")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value A list of possible values an attribute can take.
     * The following argument is optional:
     */
    @JvmName("bubbopxstmdqpowj")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values A list of possible values an attribute can take.
     * The following argument is optional:
     */
    @JvmName("ftdkewllrkixajxl")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): PermissionsLfTagArgs = PermissionsLfTagArgs(
        catalogId = catalogId,
        key = key ?: throw PulumiNullFieldException("key"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
