@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.PermissionsLfTagPolicyExpressionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property key The key-name of an LF-Tag.
 * @property values A list of possible values of an LF-Tag.
 */
public data class PermissionsLfTagPolicyExpressionArgs(
    public val key: Output<String>,
    public val values: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.PermissionsLfTagPolicyExpressionArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.PermissionsLfTagPolicyExpressionArgs =
        com.pulumi.aws.lakeformation.inputs.PermissionsLfTagPolicyExpressionArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PermissionsLfTagPolicyExpressionArgs].
 */
@PulumiTagMarker
public class PermissionsLfTagPolicyExpressionArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value The key-name of an LF-Tag.
     */
    @JvmName("bwrkjpomlcjqdpqh")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value A list of possible values of an LF-Tag.
     */
    @JvmName("vonkpmeramdmceae")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("eljssgdathvxggjw")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values A list of possible values of an LF-Tag.
     */
    @JvmName("ljjawhhcdcpedcsg")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The key-name of an LF-Tag.
     */
    @JvmName("fxcvqdfnbchpmuwk")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value A list of possible values of an LF-Tag.
     */
    @JvmName("xbfokbpelhsmhwwo")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values A list of possible values of an LF-Tag.
     */
    @JvmName("msiqurudirfowhsk")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): PermissionsLfTagPolicyExpressionArgs = PermissionsLfTagPolicyExpressionArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
