@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.PermissionsTableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogId Identifier for the Data Catalog. By default, it is the account ID of the caller.
 * @property databaseName Name of the database for the table. Unique to a Data Catalog.
 * @property name Name of the table.
 * @property wildcard Whether to use a wildcard representing every table under a database. Defaults to `false`.
 * The following arguments are optional:
 */
public data class PermissionsTableArgs(
    public val catalogId: Output<String>? = null,
    public val databaseName: Output<String>,
    public val name: Output<String>? = null,
    public val wildcard: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.PermissionsTableArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.PermissionsTableArgs =
        com.pulumi.aws.lakeformation.inputs.PermissionsTableArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .wildcard(wildcard?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PermissionsTableArgs].
 */
@PulumiTagMarker
public class PermissionsTableArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var name: Output<String>? = null

    private var wildcard: Output<Boolean>? = null

    /**
     * @param value Identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    @JvmName("bamfgyaawyrnyydp")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value Name of the database for the table. Unique to a Data Catalog.
     */
    @JvmName("soggukwkkawsugsa")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Name of the table.
     */
    @JvmName("aqowiwyjvwuodmun")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Whether to use a wildcard representing every table under a database. Defaults to `false`.
     * The following arguments are optional:
     */
    @JvmName("aaurkroxgpigjbib")
    public suspend fun wildcard(`value`: Output<Boolean>) {
        this.wildcard = value
    }

    /**
     * @param value Identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    @JvmName("kfnsjjcabkweuqlt")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value Name of the database for the table. Unique to a Data Catalog.
     */
    @JvmName("xehgqibxmndyxhqo")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Name of the table.
     */
    @JvmName("hmkeodyafmpuodhf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Whether to use a wildcard representing every table under a database. Defaults to `false`.
     * The following arguments are optional:
     */
    @JvmName("yamcfhycfbfielbr")
    public suspend fun wildcard(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wildcard = mapped
    }

    internal fun build(): PermissionsTableArgs = PermissionsTableArgs(
        catalogId = catalogId,
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        name = name,
        wildcard = wildcard,
    )
}
