@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.ResourceLfTagLfTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogId Identifier for the Data Catalog. By default, it is the account ID of the caller.
 * @property key Key name for an existing LF-tag.
 * @property value Value from the possible values for the LF-tag.
 * The following argument is optional:
 */
public data class ResourceLfTagLfTagArgs(
    public val catalogId: Output<String>? = null,
    public val key: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.ResourceLfTagLfTagArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.ResourceLfTagLfTagArgs =
        com.pulumi.aws.lakeformation.inputs.ResourceLfTagLfTagArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceLfTagLfTagArgs].
 */
@PulumiTagMarker
public class ResourceLfTagLfTagArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    @JvmName("hwjbfnfqnjevxvjb")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value Key name for an existing LF-tag.
     */
    @JvmName("kjkdljpdyxhdipng")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Value from the possible values for the LF-tag.
     * The following argument is optional:
     */
    @JvmName("kamneqggmkmnwfte")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    @JvmName("ljhkcbxewfeiyxet")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value Key name for an existing LF-tag.
     */
    @JvmName("eodnfjnmgsontsrh")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Value from the possible values for the LF-tag.
     * The following argument is optional:
     */
    @JvmName("bheyyomnbjasjojv")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ResourceLfTagLfTagArgs = ResourceLfTagLfTagArgs(
        catalogId = catalogId,
        key = key ?: throw PulumiNullFieldException("key"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
