@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.ResourceLfTagTableWithColumnsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property catalogId Identifier for the Data Catalog. By default, it is the account ID of the caller.
 * @property columnNames Set of column names for the table.
 * @property columnWildcard Option to add column wildcard. See Column Wildcard for more details.
 * @property databaseName Name of the database for the table with columns resource. Unique to the Data Catalog.
 * @property name Name of the table resource.
 * The following arguments are optional:
 */
public data class ResourceLfTagTableWithColumnsArgs(
    public val catalogId: Output<String>? = null,
    public val columnNames: Output<List<String>>? = null,
    public val columnWildcard: Output<ResourceLfTagTableWithColumnsColumnWildcardArgs>? = null,
    public val databaseName: Output<String>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.ResourceLfTagTableWithColumnsArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.ResourceLfTagTableWithColumnsArgs =
        com.pulumi.aws.lakeformation.inputs.ResourceLfTagTableWithColumnsArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .columnNames(columnNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .columnWildcard(columnWildcard?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .databaseName(databaseName.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceLfTagTableWithColumnsArgs].
 */
@PulumiTagMarker
public class ResourceLfTagTableWithColumnsArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var columnNames: Output<List<String>>? = null

    private var columnWildcard: Output<ResourceLfTagTableWithColumnsColumnWildcardArgs>? = null

    private var databaseName: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    @JvmName("xrudvuwgxrahmvjb")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value Set of column names for the table.
     */
    @JvmName("ieqbrwvglktikprs")
    public suspend fun columnNames(`value`: Output<List<String>>) {
        this.columnNames = value
    }

    @JvmName("fbberbtubdfroohl")
    public suspend fun columnNames(vararg values: Output<String>) {
        this.columnNames = Output.all(values.asList())
    }

    /**
     * @param values Set of column names for the table.
     */
    @JvmName("qgbgomptsxuififr")
    public suspend fun columnNames(values: List<Output<String>>) {
        this.columnNames = Output.all(values)
    }

    /**
     * @param value Option to add column wildcard. See Column Wildcard for more details.
     */
    @JvmName("jwqxqdfvjjjbwsii")
    public suspend fun columnWildcard(`value`: Output<ResourceLfTagTableWithColumnsColumnWildcardArgs>) {
        this.columnWildcard = value
    }

    /**
     * @param value Name of the database for the table with columns resource. Unique to the Data Catalog.
     */
    @JvmName("thwlidpqonpilwpq")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Name of the table resource.
     * The following arguments are optional:
     */
    @JvmName("sjeibwmbomwvjlan")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    @JvmName("gsmjoaipdfsthmiv")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value Set of column names for the table.
     */
    @JvmName("xxwquogxsneiayrl")
    public suspend fun columnNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columnNames = mapped
    }

    /**
     * @param values Set of column names for the table.
     */
    @JvmName("cagivdfxnikvtdsg")
    public suspend fun columnNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columnNames = mapped
    }

    /**
     * @param value Option to add column wildcard. See Column Wildcard for more details.
     */
    @JvmName("swccqugshmuwylqc")
    public suspend fun columnWildcard(`value`: ResourceLfTagTableWithColumnsColumnWildcardArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columnWildcard = mapped
    }

    /**
     * @param argument Option to add column wildcard. See Column Wildcard for more details.
     */
    @JvmName("koaefuaaesswaite")
    public suspend fun columnWildcard(argument: suspend ResourceLfTagTableWithColumnsColumnWildcardArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceLfTagTableWithColumnsColumnWildcardArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.columnWildcard = mapped
    }

    /**
     * @param value Name of the database for the table with columns resource. Unique to the Data Catalog.
     */
    @JvmName("desowbrapbafmknj")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Name of the table resource.
     * The following arguments are optional:
     */
    @JvmName("houbeycpynjdacrt")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ResourceLfTagTableWithColumnsArgs = ResourceLfTagTableWithColumnsArgs(
        catalogId = catalogId,
        columnNames = columnNames,
        columnWildcard = columnWildcard,
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
