@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.ResourceLfTagsLfTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogId Identifier for the Data Catalog. By default, it is the account ID of the caller.
 * @property key Key name for an existing LF-tag.
 * @property value Value from the possible values for the LF-tag.
 * The following argument is optional:
 */
public data class ResourceLfTagsLfTagArgs(
    public val catalogId: Output<String>? = null,
    public val key: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.ResourceLfTagsLfTagArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.ResourceLfTagsLfTagArgs =
        com.pulumi.aws.lakeformation.inputs.ResourceLfTagsLfTagArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceLfTagsLfTagArgs].
 */
@PulumiTagMarker
public class ResourceLfTagsLfTagArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    @JvmName("hqslnypuwkjubxxk")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value Key name for an existing LF-tag.
     */
    @JvmName("awintewmtfevkiar")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Value from the possible values for the LF-tag.
     * The following argument is optional:
     */
    @JvmName("bmimcbrcddmxrxak")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    @JvmName("drrslwqjwdhaocsw")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value Key name for an existing LF-tag.
     */
    @JvmName("ocagmpjajblassqp")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Value from the possible values for the LF-tag.
     * The following argument is optional:
     */
    @JvmName("vkhgqapbmcxdtbmf")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ResourceLfTagsLfTagArgs = ResourceLfTagsLfTagArgs(
        catalogId = catalogId,
        key = key ?: throw PulumiNullFieldException("key"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
