@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property columnNames A list of column names and/or nested column attributes.
 * @property columnWildcard A wildcard with exclusions. See Column Wildcard below for details.
 * @property databaseName The name of the database.
 * @property name The name of the data cells filter.
 * @property rowFilter A PartiQL predicate. See Row Filter below for details.
 * @property tableCatalogId The ID of the Data Catalog.
 * @property tableName The name of the table.
 * @property versionId ID of the data cells filter version.
 */
public data class DataCellsFilterTableData(
    public val columnNames: List<String>? = null,
    public val columnWildcard: DataCellsFilterTableDataColumnWildcard? = null,
    public val databaseName: String,
    public val name: String,
    public val rowFilter: DataCellsFilterTableDataRowFilter? = null,
    public val tableCatalogId: String,
    public val tableName: String,
    public val versionId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lakeformation.outputs.DataCellsFilterTableData): DataCellsFilterTableData = DataCellsFilterTableData(
            columnNames = javaType.columnNames().map({ args0 -> args0 }),
            columnWildcard = javaType.columnWildcard().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lakeformation.kotlin.outputs.DataCellsFilterTableDataColumnWildcard.Companion.toKotlin(args0)
                })
            }).orElse(null),
            databaseName = javaType.databaseName(),
            name = javaType.name(),
            rowFilter = javaType.rowFilter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lakeformation.kotlin.outputs.DataCellsFilterTableDataRowFilter.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tableCatalogId = javaType.tableCatalogId(),
            tableName = javaType.tableName(),
            versionId = javaType.versionId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
