@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property permissions List of permissions that are granted to the principal. Valid values may include `ALL`, `SELECT`, `ALTER`, `DROP`, `DELETE`, `INSERT`, `DESCRIBE`, and `CREATE_TABLE`. For more details, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
 * @property principal Principal who is granted permissions. To enforce metadata and underlying data access control only by IAM on new databases and tables set `principal` to `IAM_ALLOWED_PRINCIPALS` and `permissions` to `["ALL"]`.
 */
public data class DataLakeSettingsCreateDatabaseDefaultPermission(
    public val permissions: List<String>? = null,
    public val principal: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lakeformation.outputs.DataLakeSettingsCreateDatabaseDefaultPermission): DataLakeSettingsCreateDatabaseDefaultPermission =
            DataLakeSettingsCreateDatabaseDefaultPermission(
                permissions = javaType.permissions().map({ args0 -> args0 }),
                principal = javaType.principal().map({ args0 -> args0 }).orElse(null),
            )
    }
}
