@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDataLakeSettings.
 * @property admins List of ARNs of AWS Lake Formation principals (IAM users or roles).
 * @property allowExternalDataFiltering Whether to allow Amazon EMR clusters to access data managed by Lake Formation.
 * @property allowFullTableExternalDataAccess Whether to allow a third-party query engine to get data access credentials without session tags when a caller has full data access permissions.
 * @property authorizedSessionTagValueLists Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
 * @property catalogId
 * @property createDatabaseDefaultPermissions Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
 * @property createTableDefaultPermissions Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
 * @property externalDataFilteringAllowLists A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property readOnlyAdmins List of ARNs of AWS Lake Formation principals (IAM users or roles) with only view access to the resources.
 * @property trustedResourceOwners List of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs).
 */
public data class GetDataLakeSettingsResult(
    public val admins: List<String>,
    public val allowExternalDataFiltering: Boolean,
    public val allowFullTableExternalDataAccess: Boolean,
    public val authorizedSessionTagValueLists: List<String>,
    public val catalogId: String? = null,
    public val createDatabaseDefaultPermissions: List<GetDataLakeSettingsCreateDatabaseDefaultPermission>,
    public val createTableDefaultPermissions: List<GetDataLakeSettingsCreateTableDefaultPermission>,
    public val externalDataFilteringAllowLists: List<String>,
    public val id: String,
    public val readOnlyAdmins: List<String>,
    public val trustedResourceOwners: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lakeformation.outputs.GetDataLakeSettingsResult): GetDataLakeSettingsResult = GetDataLakeSettingsResult(
            admins = javaType.admins().map({ args0 -> args0 }),
            allowExternalDataFiltering = javaType.allowExternalDataFiltering(),
            allowFullTableExternalDataAccess = javaType.allowFullTableExternalDataAccess(),
            authorizedSessionTagValueLists = javaType.authorizedSessionTagValueLists().map({ args0 -> args0 }),
            catalogId = javaType.catalogId().map({ args0 -> args0 }).orElse(null),
            createDatabaseDefaultPermissions = javaType.createDatabaseDefaultPermissions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lakeformation.kotlin.outputs.GetDataLakeSettingsCreateDatabaseDefaultPermission.Companion.toKotlin(args0)
                })
            }),
            createTableDefaultPermissions = javaType.createTableDefaultPermissions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lakeformation.kotlin.outputs.GetDataLakeSettingsCreateTableDefaultPermission.Companion.toKotlin(args0)
                })
            }),
            externalDataFilteringAllowLists = javaType.externalDataFilteringAllowLists().map({ args0 ->
                args0
            }),
            id = javaType.id(),
            readOnlyAdmins = javaType.readOnlyAdmins().map({ args0 -> args0 }),
            trustedResourceOwners = javaType.trustedResourceOwners().map({ args0 -> args0 }),
        )
    }
}
