@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property catalogId Identifier for the Data Catalog. By default, it is the account ID of the caller.
 * @property name Name of the database resource. Unique to the Data Catalog.
 * The following argument is optional:
 */
public data class GetPermissionsDatabase(
    public val catalogId: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lakeformation.outputs.GetPermissionsDatabase): GetPermissionsDatabase = GetPermissionsDatabase(
            catalogId = javaType.catalogId(),
            name = javaType.name(),
        )
    }
}
