@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property catalogId Identifier for the Data Catalog. By default, it is the account ID of the caller.
 * @property key Key-name for the tag.
 * @property values List of possible values an attribute can take.
 * The following argument is optional:
 */
public data class GetPermissionsLfTag(
    public val catalogId: String,
    public val key: String,
    public val values: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lakeformation.outputs.GetPermissionsLfTag): GetPermissionsLfTag = GetPermissionsLfTag(
            catalogId = javaType.catalogId(),
            key = javaType.key(),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
