@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property key Key-name of an LF-Tag.
 * @property values List of possible values of an LF-Tag.
 */
public data class GetPermissionsLfTagPolicyExpression(
    public val key: String,
    public val values: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lakeformation.outputs.GetPermissionsLfTagPolicyExpression): GetPermissionsLfTagPolicyExpression = GetPermissionsLfTagPolicyExpression(
            key = javaType.key(),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
