@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPermissions.
 * @property catalogId
 * @property catalogResource
 * @property dataCellsFilter
 * @property dataLocation
 * @property database
 * @property id The provider-assigned unique ID for this managed resource.
 * @property lfTag
 * @property lfTagPolicy
 * @property permissions List of permissions granted to the principal. For details on permissions, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
 * @property permissionsWithGrantOptions Subset of `permissions` which the principal can pass.
 * @property principal
 * @property table
 * @property tableWithColumns
 */
public data class GetPermissionsResult(
    public val catalogId: String? = null,
    public val catalogResource: Boolean? = null,
    public val dataCellsFilter: GetPermissionsDataCellsFilter,
    public val dataLocation: GetPermissionsDataLocation,
    public val database: GetPermissionsDatabase,
    public val id: String,
    public val lfTag: GetPermissionsLfTag,
    public val lfTagPolicy: GetPermissionsLfTagPolicy,
    public val permissions: List<String>,
    public val permissionsWithGrantOptions: List<String>,
    public val principal: String,
    public val table: GetPermissionsTable,
    public val tableWithColumns: GetPermissionsTableWithColumns,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lakeformation.outputs.GetPermissionsResult): GetPermissionsResult = GetPermissionsResult(
            catalogId = javaType.catalogId().map({ args0 -> args0 }).orElse(null),
            catalogResource = javaType.catalogResource().map({ args0 -> args0 }).orElse(null),
            dataCellsFilter = javaType.dataCellsFilter().let({ args0 ->
                com.pulumi.aws.lakeformation.kotlin.outputs.GetPermissionsDataCellsFilter.Companion.toKotlin(args0)
            }),
            dataLocation = javaType.dataLocation().let({ args0 ->
                com.pulumi.aws.lakeformation.kotlin.outputs.GetPermissionsDataLocation.Companion.toKotlin(args0)
            }),
            database = javaType.database().let({ args0 ->
                com.pulumi.aws.lakeformation.kotlin.outputs.GetPermissionsDatabase.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            lfTag = javaType.lfTag().let({ args0 ->
                com.pulumi.aws.lakeformation.kotlin.outputs.GetPermissionsLfTag.Companion.toKotlin(args0)
            }),
            lfTagPolicy = javaType.lfTagPolicy().let({ args0 ->
                com.pulumi.aws.lakeformation.kotlin.outputs.GetPermissionsLfTagPolicy.Companion.toKotlin(args0)
            }),
            permissions = javaType.permissions().map({ args0 -> args0 }),
            permissionsWithGrantOptions = javaType.permissionsWithGrantOptions().map({ args0 -> args0 }),
            principal = javaType.principal(),
            table = javaType.table().let({ args0 ->
                com.pulumi.aws.lakeformation.kotlin.outputs.GetPermissionsTable.Companion.toKotlin(args0)
            }),
            tableWithColumns = javaType.tableWithColumns().let({ args0 ->
                com.pulumi.aws.lakeformation.kotlin.outputs.GetPermissionsTableWithColumns.Companion.toKotlin(args0)
            }),
        )
    }
}
