@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property catalogId Identifier for the Data Catalog. By default, it is the account ID of the caller.
 * @property columnNames Set of column names for the table. At least one of `column_names` or `excluded_column_names` is required.
 * @property databaseName Name of the database for the table with columns resource. Unique to the Data Catalog.
 * @property excludedColumnNames Set of column names for the table to exclude. At least one of `column_names` or `excluded_column_names` is required.
 * @property name Name of the table resource.
 * The following arguments are optional:
 * @property wildcard Whether to use a wildcard representing every table under a database. At least one of `name` or `wildcard` is required. Defaults to `false`.
 */
public data class GetPermissionsTableWithColumns(
    public val catalogId: String,
    public val columnNames: List<String>? = null,
    public val databaseName: String,
    public val excludedColumnNames: List<String>? = null,
    public val name: String,
    public val wildcard: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lakeformation.outputs.GetPermissionsTableWithColumns): GetPermissionsTableWithColumns = GetPermissionsTableWithColumns(
            catalogId = javaType.catalogId(),
            columnNames = javaType.columnNames().map({ args0 -> args0 }),
            databaseName = javaType.databaseName(),
            excludedColumnNames = javaType.excludedColumnNames().map({ args0 -> args0 }),
            name = javaType.name(),
            wildcard = javaType.wildcard().map({ args0 -> args0 }).orElse(null),
        )
    }
}
