@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property databaseName The name of the database.
 * @property name The name of the data cells filter.
 * @property tableCatalogId The ID of the Data Catalog.
 * @property tableName The name of the table.
 */
public data class PermissionsDataCellsFilter(
    public val databaseName: String,
    public val name: String,
    public val tableCatalogId: String,
    public val tableName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lakeformation.outputs.PermissionsDataCellsFilter): PermissionsDataCellsFilter = PermissionsDataCellsFilter(
            databaseName = javaType.databaseName(),
            name = javaType.name(),
            tableCatalogId = javaType.tableCatalogId(),
            tableName = javaType.tableName(),
        )
    }
}
