@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property catalogId Identifier for the Data Catalog. By default, it is the account ID of the caller.
 * @property key The key-name for the tag.
 * @property values A list of possible values an attribute can take.
 * The following argument is optional:
 */
public data class PermissionsLfTag(
    public val catalogId: String? = null,
    public val key: String,
    public val values: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lakeformation.outputs.PermissionsLfTag): PermissionsLfTag = PermissionsLfTag(
            catalogId = javaType.catalogId().map({ args0 -> args0 }).orElse(null),
            key = javaType.key(),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
