@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property catalogId Identifier for the Data Catalog. By default, it is the account ID of the caller.
 * @property expressions A list of tag conditions that apply to the resource's tag policy. Configuration block for tag conditions that apply to the policy. See `expression` below.
 * The following argument is optional:
 * @property resourceType The resource type for which the tag policy applies. Valid values are `DATABASE` and `TABLE`.
 */
public data class PermissionsLfTagPolicy(
    public val catalogId: String? = null,
    public val expressions: List<PermissionsLfTagPolicyExpression>,
    public val resourceType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lakeformation.outputs.PermissionsLfTagPolicy): PermissionsLfTagPolicy = PermissionsLfTagPolicy(
            catalogId = javaType.catalogId().map({ args0 -> args0 }).orElse(null),
            expressions = javaType.expressions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lakeformation.kotlin.outputs.PermissionsLfTagPolicyExpression.Companion.toKotlin(args0)
                })
            }),
            resourceType = javaType.resourceType(),
        )
    }
}
