@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property key The key-name of an LF-Tag.
 * @property values A list of possible values of an LF-Tag.
 */
public data class PermissionsLfTagPolicyExpression(
    public val key: String,
    public val values: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lakeformation.outputs.PermissionsLfTagPolicyExpression): PermissionsLfTagPolicyExpression = PermissionsLfTagPolicyExpression(
            key = javaType.key(),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
