@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property catalogId Identifier for the Data Catalog. By default, it is the account ID of the caller.
 * @property key Key name for an existing LF-tag.
 * @property value Value from the possible values for the LF-tag.
 * The following argument is optional:
 */
public data class ResourceLfTagLfTag(
    public val catalogId: String? = null,
    public val key: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lakeformation.outputs.ResourceLfTagLfTag): ResourceLfTagLfTag = ResourceLfTagLfTag(
            catalogId = javaType.catalogId().map({ args0 -> args0 }).orElse(null),
            key = javaType.key(),
            `value` = javaType.`value`(),
        )
    }
}
