@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property catalogId Identifier for the Data Catalog. By default, it is the account ID of the caller.
 * @property databaseName Name of the database for the table. Unique to a Data Catalog.
 * @property name Name of the table.
 * @property wildcard Whether to use a wildcard representing every table under a database. Defaults to `false`.
 * The following arguments are optional:
 */
public data class ResourceLfTagTable(
    public val catalogId: String? = null,
    public val databaseName: String,
    public val name: String? = null,
    public val wildcard: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lakeformation.outputs.ResourceLfTagTable): ResourceLfTagTable = ResourceLfTagTable(
            catalogId = javaType.catalogId().map({ args0 -> args0 }).orElse(null),
            databaseName = javaType.databaseName(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            wildcard = javaType.wildcard().map({ args0 -> args0 }).orElse(null),
        )
    }
}
